Imports System.Runtime.Serialization.Formatters.Binary
Imports System.Runtime.Serialization.Formatters.Soap
Imports System.Xml.Serialization
Imports System.IO

Public Enum SerialTyp
 SOAP
 XML
 BINARY
End Enum

Module Serialisieren_Hilfsroutinen

 ' ### Serialisieren in Datei
 Sub save(ByVal Typ As SerialTyp, ByVal obj As Object, ByVal datei As String)
  ' Datei ffnen
  Dim stream As FileStream
  stream = New FileStream(datei, FileMode.Create, FileAccess.Write, FileShare.None)
  ' Fallunterscheidung
  Dim Serializer As Object
  Select Case Typ
   Case SerialTyp.BINARY
    Serializer = New BinaryFormatter()
   Case SerialTyp.SOAP
    Serializer = New SoapFormatter()
   Case SerialTyp.XML
    Serializer = New XmlSerializer(obj.GetType)
   Case Else
    MsgBox("Nicht untersttztes Serialiserungsformat!")
    End
  End Select
  ' Serialisierung starten
  Serializer.Serialize(stream, obj)
  ' Datei schlieen
  stream.Close()
  ' Ausgabe
  out("Objekt wurde gespeichert in " & datei)
 End Sub

 ' ### Deserialisieren aus Datei
 Function load(ByVal typ As SerialTyp, ByVal Datei As String, Optional ByVal Objekttyp As Type = Nothing) As Object
  ' Datei ffnen
  Dim stream As FileStream
  stream = New FileStream(Datei, FileMode.Open)
  ' Fallunterscheidung
  Dim Serializer As Object
  Select Case typ
   Case SerialTyp.BINARY
    Serializer = New BinaryFormatter()
   Case SerialTyp.SOAP
    Serializer = New SoapFormatter()
   Case SerialTyp.XML
    If Objekttyp Is Nothing Then
     MsgBox("Fehler: Fr den XML-Deserialisierer muss der zu deserialisierende Objekttyp bekannt sein!")
     End
    End If
    Serializer = New XmlSerializer(Objekttyp)
   Case Else
    MsgBox("Nicht untersttztes Serialiserungsformat!")
    End
  End Select
  ' Deserialisierung
  Dim o As Object
  o = Serializer.Deserialize(stream)
  ' Datei schliessen
  stream.Close()
  ' Ausgabe
  out("Objekt wurde geladen aus " & Datei)
  ' Objekt zurckliefern
  Return o
 End Function






 ' ### Serialisieren in Bytfolge
 'Function save(SerialTyp.bin,(ByVal o As Object) As Byte()
 ' Dim form As New BinaryFormatter()
 ' Dim stream As New MemoryStream()
 ' form.Serialize(stream, o)
 ' stream.Close()
 ' out("Objekt serialisiert!")
 ' Return (stream.ToArray)
 'End Function

 '' ### Deserialisieren aus einer Binrdatei
 'Function load(SerialTyp.Binary,ByVal Datei As String) As Object
 ' Dim o As Object
 ' Dim form As New BinaryFormatter()
 ' Dim stream As FileStream
 ' stream = New FileStream(Datei, FileMode.Open)
 ' o = form.Deserialize(stream)
 ' stream.Close()
 ' out("Objekt wurde geladen aus " & Datei)
 ' Return o
 'End Function

 '' ### Deserialisieren aus einer Bytefolge
 'Function load(SerialTyp.Binary,ByVal ba As Byte()) As Object
 ' Dim o As Object
 ' Dim form As New BinaryFormatter()
 ' Dim stream As New MemoryStream(ba)
 ' o = form.Deserialize(stream)
 ' stream.Close()
 ' out("Objekt wurde deserialisiert")
 ' Return o
 'End Function


 '' ### SOAP-Deserialisieren aus einer Binrdatei
 'Function load(SerialTyp.soap,ByVal Datei As String) As Object
 ' Dim o As Object
 ' Dim form As New SoapFormatter()
 ' Dim stream As FileStream
 ' stream = New FileStream(Datei, FileMode.Open)
 ' o = form.Deserialize(stream)
 ' stream.Close()
 ' out("Objekt wurde geladen aus " & Datei)
 ' Return o
 'End Function


 '' ### Deserialisieren aus XML-Datei
 'Function load(ByVal t As Type, ByVal datei As String) As Object
 ' Dim obj As Object
 ' Dim reader As New StreamReader(datei)
 ' Dim serializer As New XmlSerializer(t)
 ' obj = serializer.Deserialize(reader)
 ' out("Objekt wurde geladen aus " & datei)
 ' reader.Close()
 ' Return (obj)
 'End Function

 '' ### XML-Serialisieren in String
 Function xml_deserialize_string(ByVal obj As Object) As String
  Dim serializer As New XmlSerializer(obj.GetType)
  Dim s As String

  ' --- Serialisieren in MemoryStream
  Dim ms As New MemoryStream()
  serializer.Serialize(ms, obj)
  out("Objekt wurde serialisiert!")

  ' --- Stream in String umwandeln   
  Dim r As StreamReader = New StreamReader(ms)
  r.BaseStream.Seek(0, SeekOrigin.Begin)
  s = r.ReadToEnd

  ' Alternative:
  'Dim b As Byte
  'Dim ba As Byte()
  'ba = ms.ToArray
  'For Each b In ba
  '  s = s & Convert.ToChar(b)
  'Next

  Return s
 End Function

 ' ### Zeichenweise Umwandlung eines Memory-Streams in einen String
 Function ms_to_string(ByVal ms As MemoryStream) As String
  Dim s As String
  Dim b As Byte
  Dim ba As Byte()
  ba = ms.ToArray
  For Each b In ba
   s = s & Chr(b)
  Next
  Return s
 End Function

 ' ### Deserialisieren aus XML-String
 Function xml_deserialize_string(ByVal t As Type, ByVal s As String) As Object
  Dim obj As Object
  ' --- Objekt in Stream kopieren
  Dim stream As New MemoryStream()
  Dim w As New StreamWriter(stream)
  w.BaseStream.Seek(0, SeekOrigin.End)
  w.WriteLine(s)
  w.Close()
  ' Stream umkopieren, weil jetzt geschlossen
  stream = New MemoryStream(stream.ToArray)
  Dim serializer As New XmlSerializer(t)
  obj = serializer.Deserialize(stream)
  out("Objekt wurde deserialisiert!")
  stream.Close()
  Return (obj)
 End Function
End Module
