Imports System.Xml.Serialization


Module Serialisierung_Objektmodell

 ' === Beispiele fr Binres und XML serialisieren
 Sub OModell_Serialisieren()

  ' --- Objektmodell aufbauen
  Dim a As New Buchautor("Holger Schwichtenberg")
  a.Geb = #8/1/1972#

  Dim v As New Verlag()
  v.Name = "Addison Wesley"

  Dim b1 As New Buch("Windows Scripting")

  b1.Auflagen.Add(New Auflage(1, 2000, "3-8273-1637-5"))
  b1.Auflagen.Add(New Auflage(2, 2001, "3-8273-1843-2"))
  b1.Auflagen.Add(New Auflage(3, 2002, "3-8273-2061-5"))
  b1.Verlag = v

  Dim b2 = New Buch("ASP.NET - Das Entwicklerbuch")

  b2.Auflagen.add(New Auflage(1, 2002, "3-86063-667-7"))
  b2.verlag = New Verlag("MSPress")

  Dim b3 = New Buch("Programmieren mit der .NET-Klassenbibliothek")
  b3.Auflagen.Add(New Auflage(1, 2002, "3-8273-1905-6"))
  b3.verlag = v

  a.buecher.Add(b2)
  a.buecher.Add(b1)
  a.buecher.Add(b3)

  ' --- Variante: zweifacher Verweis auf ein Objekt
  'a.b1 = b1
  'a.b2 = b1

  ' --- Objektmodell ausgeben
  autorinfo(a)

  Dim o As Object ' Objekt fr Deserialisierung

  ' --- Serialisierungsziele
  Const DATEI = "..\_daten\Serial\buch.bin"
  Const DATEISOAP = "..\_daten\Serial\buch.soap.xml"
  Const DATEIXML = "..\_daten\Serial\buch.xml"

  ' --- binre Serialisieren
  out("Binre Serialisierung...")
  save(SerialTyp.BINARY, a, DATEI)
  o = load(SerialTyp.Binary, DATEI)
  autorinfo(o)

  ' --- binre Serialisieren
  out("Binre Serialisierung...")
  save(SerialTyp.SOAP, a, DATEISOAP)
  o = load(SerialTyp.soap, DATEISOAP)
  autorinfo(o)

  ' --- XML-Serialisieren
  out("XML Serialisierung...")
  save(SerialTyp.XML, a, DATEIXML)
  o = load(SerialTyp.XML, DATEIXML, GetType(Buchautor))
  autorinfo(o)

  ' --- Anlegen einer zirkulren Referenz
  b1.Autor = a
  b2.autor = a
  b3.autor = a

  ' --- binre Serialisieren
  out("Binre Serialisierung...")
  save(SerialTyp.BINARY, a, DATEI)
  ' --- Deserialisieren
  a = load(SerialTyp.Binary, DATEI)
  autorinfo(a)

  '' --- XML-Serialisieren
  'out("XML Serialisierung...")
  'Try
  '  save(SerialTyp.XML,a, DATEIXML)
  '  a = load(SerialTyp.xml,GetType(autor), DATEIXML)
  '  autorinfo(a)
  'Catch e As Exception
  '  out("Serialisierung nicht mglich: " & e.ToString)
  'End Try
 End Sub

 ' === Ausgabe des Objektmodell
 Sub autorinfo(ByVal a As Buchautor)
  Dim b As Buch
  out("Autor: " & a.Name & ", " & a.buecher.Count & " Bcher")
  For Each b In a.buecher
   out("Buch: " & b.Titel)
   If Not b.Autor Is Nothing Then out("von " & b.Autor.Name)
  Next
 End Sub


End Module
