Option Strict Off
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.Runtime.Serialization
Imports System.IO
Imports System.Xml.Serialization



Public Module Samples_Serialisieren_Kontrolle

  ' === Klasse fr benutzerdefinierte Serialisierung
  <Serializable()> Public Class Person2
    Implements ISerializable, IDeserializationCallback
    Public Name As String
    Public Vorname As String
    Public Geb As Date
    Public Geschlecht As Char
    Public Kinderanzahl As Byte
    Public Taetigkeiten As String()
    <NonSerialized()> Public Deserialisiert As Date

    Public Sub New()
      out("Konstruktoraufruf!")
    End Sub

    ' --- Serialisierung ausgewhlter Eigenschaften
    Public Sub GetObjectData(ByVal info As SerializationInfo, ByVal context As StreamingContext) Implements ISerializable.GetObjectData
      out("Serialisierung des Typs: " & info.FullTypeName.ToString)
      info.AddValue("kompletterName", Vorname & " " & Name)
      info.AddValue("Geb", Geb)
    End Sub

    ' --- Deserialisierung ausgewhlter Eigenschaften
    Public Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
      Dim namen As String()
      namen = CType(info.GetValue("kompletterName", GetType(String)), String).Split
      Vorname = namen(0)
      Name = namen(1)
      Geb = CDate(info.GetValue("Geb", GetType(Date)))
    End Sub

    ' --- wird am Ende der Deserialisierung aufgerufen
    Public Sub OnDeserialization(ByVal s As Object) Implements IDeserializationCallback.OnDeserialization
      Deserialisiert = Now
      out("Deserialisierung komplett!")
    End Sub

  End Class

  ' === Benutzerdefinierte Serialisierung
  Sub serial_kontrolle_1()
    Const DATEI = "..\_daten\person.bin"

    ' --- Objekt fllen
  Dim a As New Person2()
  a.Vorname = "Holger"
  a.Name = "Schwichtenberg"
  a.Geb = #8/1/1972#
  a.Geschlecht = "m"
  a.Kinderanzahl = 0
  a.Taetigkeiten = New String() {"Berater", "Entwickler", "Journalist", "Dozent"}

  Dim form As New BinaryFormatter()
  Dim stream As FileStream

  ' --- Serialisieren
  stream = New FileStream(DATEI, FileMode.Create, FileAccess.Write, FileShare.None)
  form.Serialize(stream, a)
  stream.Close()
  out("Objekt wurde gespeichert!")
  a = Nothing

  ' --- Deserialisieren
  stream = New FileStream(DATEI, FileMode.Open, FileAccess.Read, FileShare.Read)
  a = form.Deserialize(stream)
  stream.Close()
  out("Objekt wurde geladen!")
  out(a.Vorname & " " & a.Name & " hat am " & a.Geb & " Geburtstag!")

 End Sub

 <Serializable()> Public Class Person3
  Public Name As String
  Public Vorname As String
  Public Taetigkeiten As String()
  Public gehalt As Byte
  <XmlAttributeAttribute()> Public Geschlecht As Char
  <System.NonSerialized()> Public Geb As Date  ' Attribut wirkt nicht auf XML-Serialisierer
  <XmlIgnore()> Public Kinderanzahl As Byte

 End Class

 Sub serial_kontrolle_2()
  Dim a As New Person3()

  outtitle("Benutzerdef_XML_Serialisieren_test()")


  a.Vorname = "Holger"
  a.Name = "Schwichtenberg"
  a.Geb = #8/1/1972#
  a.Geschlecht = "m"
  a.Kinderanzahl = 0
  a.gehalt = 6
  save(SerialTyp.XML, a, "..\_daten\person3.xml")
  save(SerialTyp.BINARY, a, "..\_daten\person3.bin")
  save(SerialTyp.XML, a, "..\_daten\person3.soaa.xml")

  Try
   a = load(SerialTyp.XML, "..\_daten\serial\person3.xml", a.GetType)
   out(a.Vorname & " " & a.Name & " hat am " & a.Geb & " Geburtstag!")
  Catch e As Exception
   out("XML Deserialisierung nicht mglich: " & e.Message)
  End Try
  Try
   a = load(SerialTyp.BINARY, "..\_daten\serial\person3.bin")
   out(a.Vorname & " " & a.Name & " hat am " & a.Geb & " Geburtstag!")
  Catch e As Exception
   out("Binre Deserialisierung nicht mglich: " & e.Message)
  End Try
  Try
   a = load(SerialTyp.SOAP, "..\_daten\serial\person3.soaa.xml")
   out(a.Vorname & " " & a.Name & " hat am " & a.Geb & " Geburtstag!")
  Catch e As Exception
   out("SOAP Deserialisierung nicht mglich: " & e.Message)
  End Try
 End Sub
End Module

