using System;
using de.ITVisions.DemoViewer;

namespace NET2.SpracheCSharp
{

 public class Person
 {
  public string Name;
 }

 public class CLSTest
 {


   System.UInt64 testvar;
   System.UInt64 Testvar;

  public void Test()
  {
   Person HS = new Person();
   HS.Name = "Holger Schwichtenberg";

   Person XY = HS;
   XY.Name = "unbekannt";

   Int16 z = 6;
   Int16 y = z;
   y = 5;

  }
 }

[Demo]
 public class Datentypen
 {

  public void NullableTypes_Buchversion()
  {
   int a = 1;
   // Elegante Deklaration in C#
   int? b = 2;

   // a = null; // verboten!
   b = null; // Erlaubt

   // Explizite Deklaration
   System.Nullable<Int32> c = null;
   c = 100;

   Demo.Print(c.HasValue.ToString());
   Demo.Print(c.Value.ToString()); // Achtung: Geht nur, wenn c tatschlich einen Wert hat!

  // Besser: "Null" abfangen
   Demo.Print("b = " + (b.HasValue ? b.Value.ToString() : "null"));
  }


  public void NullableTypes_Ausfuehrlich()
  {

   // Werttyp ohne Null
   int a = 1;
   long b = 0;
   // Werttyp mit Null erlaubt
   int? x = 2;
   System.Nullable<Int64> y = 6;

   // a = null; // verboten!
   x = null; // Erlaubt
   //    y = x.Value; // verboten, wenn x = null
   Demo.Print("a=" + a);
   Demo.Print("b=" + b);
   Demo.Print("x=" + x + " Wert? " + x.HasValue);
   //Demo.Print("x=" + x.Value + " Wert? " + x.HasValue);
   Demo.Print("y=" + y.Value + " Wert? " + y.HasValue);

   // erlaubt
   a = (int) b;
   x = (int?) y;

   y = x + 10; // null + Zahl = null
   x = a;
   string s2 = x.ToString();
   string s3 = x.HasValue.ToString(); 
   // nicht erlaubt
   //  a = x; --> Error	49	Cannot implicitly convert type 'int?' to 'int'. An explicit conversion exists (are you missing a cast?)
   //    b = x + 10;
	// erlaubt, aber Laufzeitfehler, falls x = null
   x = null;
   a = (int)x;
   string s4 = x.Value.ToString();

   //besser:
   a = x ?? 0;

   // Explizite Deklaration

   Demo.Print(y.HasValue.ToString());
   Demo.Print(y.Value.ToString()); // Achtung: Geht nur, wenn c tatschlich einen Wert hat!

   // Besser: "Null" abfangen
   Demo.Print ("b = " + ( x.HasValue ? x.Value.ToString() : "null"));

   // Neuer ?? Operator
   // --------------------------

   // Umwandlung eines Nullable Int in einen Int
   int? d = null;
   int e = d ?? -1;

   // Behandlung eines Strings
   string s = null;
   Demo.Print ("s = " + (s ?? "(kein Inhalt)"));

   // geht nicht Demo.Print("d = " + (d ?? "null"));

  // Demo.Print("d = " + (d ?? "null"));
  }

  [System.CLSCompliant(false)]
 public void CLSKonformitaet()
  {
  UInt16 i = 16;
  i++;
  }

 }

 public class boxing
	{
		public boxing()
		{

      // Beispiel: Werttyp ohne Member
			int i = 1234, i2;
      object oi, oi2;
           
      // Boxing
      oi = i;

      // Unboxing
      i2 = (int) oi;
      // or:
      i2 = Convert.ToInt32(oi);

      Demo.Print(i);
      Demo.Print(oi);
    
      i = 4567;
      
      Demo.Print(i);
      Demo.Print(oi);

      // Kopieroperationen fr int
      i2 = i;
      oi2 = oi;
      i2 = 8888;
      oi2 = 9999; 
      Demo.Print(i);
      Demo.Print(i2);
      Demo.Print(oi);
      Demo.Print(oi2);

      oi = "test";
      oi2 = oi;
      oi = "6666";

      Demo.Print(oi);
      Demo.Print(oi2);

//      oi = new Vater("1");
//      oi2 = oi;
//      ((Vater) oi).Name = "2";
//      Demo.Print(((Vater) oi).Name);
//      Demo.Print(((Vater) oi2).Name);

      // Beispiel: Wertetyp mit Membern
      Dimension d1,d2;

      d1.Length = 100;
      d1.Width = 100;

      d2 = d1;
      Demo.Print("d1.Length=" + d1.Length);
      Demo.Print("d2.Length=" + d2.Length);
     
      // Kopieroperationen fr Dimension: Referenzkopie!
      oi = d1;
      oi2 = oi;
        
    

      Demo.Print("oi.Length=" + ((Dimension) oi).Length);
      Demo.Print("oi2.Length=" + ((Dimension) oi2).Length);
		}





 public void ArrayDemo()
  {
		//int a, b, c;
		//string x, y, z;
		//System.Guid g1, g2, g3;
  int zahl = 1;
 // falsch:   string text = zahl;
 // falsch: string text = ((string) zahl);
// falsch:  string text = zahl as string;
  string text1 = zahl.ToString();
  string text2 = Convert.ToString(zahl);

  byte[] lottozahlen1 = new byte[7] { 23, 48, 3, 19, 20, 6, 9 };
  byte[] lottozahlen2 = new byte[] { 23, 48, 3, 19, 20, 6, 9 };
   byte[] lottozahlen3 = { 23, 48, 3, 19, 20, 6, 9 };
  
  }
	}

 /// <summary>
 /// Zusammenfassung fr boxing.
 /// </summary>
 /// 
 struct Dimension
 {
  public double Length;
  public double Width;
  public Dimension(double Length, double Width)
  {
   this.Length = Length;
   this.Width = Width;
  }
 }
}
