// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================
using System;
using de.ITVisions.DemoViewer;

namespace NET2.SpracheCSharp
{
 #region Hilfsklassen

 public class Mensch
 {
  public string Name;
 }

 public class Mann : Mensch
 {
  public Mann(string Name)
  {
   this.Name = Name;
  }
 }

 public class Frau : Mensch
 {
  public Frau(string Name)
  {
   this.Name = Name;
  }
 }
 #endregion
 #region Ohne Generics
 public class DoppelFrauen
 {
  public Frau Spieler1;
  public Frau Spieler2;
 }

 public class DoppelMnner
 {
  public Mann Spieler1;
  public Mann Spieler2;
 }

 public class DoppelGemischt
 {
  public Frau Spieler1;
  public Mann Spieler2;
 }

 public class DoppelAllgemein
 {
  public Object Spieler1;
  public Object Spieler2;
 }
 #endregion
 #region Generic ohne Constraints
 public class Doppel<SpielerTyp1, SpielerTyp2>
 {
  public SpielerTyp1 Spieler1;
  public SpielerTyp2 Spieler2;

  public Doppel(SpielerTyp1 Spieler1, SpielerTyp2 Spieler2)
  {
   // Speichern der Spieler
   this.Spieler1 = Spieler1;
   this.Spieler2 = Spieler2;

   // Ausgabe
   if ((Spieler1.GetType().ToString() != Spieler2.GetType().ToString()))
   {
    Demo.Print("Neues Gemischtes Doppelt!");
   }
   else
   {
    Demo.Print("Neues Gleichgeschlechtliches Doppel!");
   }

   // Casting nur erforderlich, wenn kein Constraint!
   Demo.Print("Spieler 1 = " + (Spieler1 as Mensch).Name + "(" + Spieler1.GetType().ToString() + ")");
   Demo.Print("Spieler 2 = " + (Spieler2 as Mensch).Name + "(" + Spieler2.GetType().ToString() + ")");

  }

 }
 #endregion
 #region Generic mit Constraint
 public class Doppel_MitConstraint<SpielerTyp1, SpielerTyp2>
  where SpielerTyp1 : Mensch, new()
  where SpielerTyp2 : Mensch, new()
 {
  public SpielerTyp1 Spieler1;
  public SpielerTyp2 Spieler2;

  public Doppel_MitConstraint(SpielerTyp1 Spieler1, SpielerTyp2 Spieler2)
  {
   
   // Speichern der Spieler
   this.Spieler1 = Spieler1;
   this.Spieler2 = Spieler2;

   // Ausgabe
   if ((Spieler1.GetType().ToString() != Spieler2.GetType().ToString()))
   {
    Demo.Print("Neues Gemischtes Doppelt!");
   }
   else
   {
    Demo.Print("Neues Gleichgeschlechtliches Doppel!");
   }

   Demo.Print("Spieler 1 = " + Spieler1.Name + "(" + Spieler1.GetType().ToString() + ")");
   Demo.Print("Spieler 2 = " + Spieler2.Name + "(" + Spieler1.GetType().ToString() + ")");
  }

 }
 #endregion
 #region client
 [Demo]
 public class GenerischeKlasse_demo
 {
  public void run()
  {


   Frau f1 = new Frau("Angela Merkel");
   Frau f2 = new Frau("Rita Smuth");
   Mann m1 = new Mann("Gerhard Schrder");
   Mann m2 = new Mann("Edmund Stoiber");
   Mann m3 = new Mann("Joschka Fischer");


   System.Collections.ArrayList Politikerinnen = new System.Collections.ArrayList();

   Politikerinnen.Add(f1);
   Politikerinnen.Add(f2);
   Politikerinnen.Add(m2);

   System.Collections.Generic.List<Frau> Politikerinnen2 = new System.Collections.Generic.List<Frau>();

   Politikerinnen2.Add(f1);
   Politikerinnen2.Add(f2);
   //Politikerinnen2.Add(m2);






   Doppel<Mann, Frau> d1 = new Doppel<Mann, Frau>(m1, f1);
   Doppel<Frau, Mann> d4 = new Doppel<Frau, Mann>(f1, m2);
   Doppel<Mann, Mann> d2 = new Doppel<Mann, Mann>(m1, m2);
   Doppel<Frau, Frau> d3 = new Doppel<Frau, Frau>(f1, f2);

  // Doppel<Frau, Frau> d5 = new Doppel<Frau, Frau>(f1, m2);


   //System.IO.DirectoryInfo i = new System.IO.DirectoryInfo(@"C:\");
   //System.IO.FileInfo d = new System.IO.FileInfo(@"c:\test.txt");
   //Doppel<System.IO.DirectoryInfo, System.IO.FileInfo> o = new Doppel<System.IO.DirectoryInfo, System.IO.FileInfo>(i, d);


  //Doppel_MitConstraint<System.IO.FileInfo, System.IO.FileInfo> DateiDoppel = new Doppel_MitConstraint<System.IO.FileInfo, System.IO.FileInfo>(new System.IO.FileInfo(@"c:\temp.txt"), new System.IO.FileInfo("c:\text.txt"));


   System.Collections.ArrayList Maenner = new System.Collections.ArrayList();
   Maenner.Add(m1);
   Maenner.Add(m2);
   Maenner.Add(m3);
   Maenner.Add(f1);

   System.Collections.Generic.LinkedList<Mann> Maenner2 = new System.Collections.Generic.LinkedList<Mann>();
   Maenner2.AddFirst(m1);
   Maenner2.AddFirst(m2);
   Maenner2.AddFirst(m3);

   //System.Collections.Generic.List<Mann> mmm = new System.Collections.Generic.List<Mann>();
   //mmm.FindAll(System.Predicate<

   foreach (Mann m in Maenner2)
   {
    Demo.Print(m.Name);
   }
   //Maenner2.AddFirst(f1)


   System.IO.FileInfo datei = new System.IO.FileInfo("c:\\temp.txt");
   //Doppel<System.IO.FileInfo, Mann> x = new Doppel<System.IO.FileInfo, Mann>(datei, m1);



  
   //Maenner2.AddFirst(f);


   // Fehler:
   //Doppel<Mann, Mann> d2 = new Doppel<Mann, Mann>(m1, f);
   //Doppel<Mensch, Mensch> d2 = new Doppel<Mensch, Mensch>(m1, f2);

   //  Doppel<int, string> f2 = new Doppel<int, string>(2, "2");




   System.Collections.Generic.SortedDictionary<string, System.IO.FileInfo> dateien =
    new System.Collections.Generic.SortedDictionary<string, System.IO.FileInfo>();

   
   dateien.Add("Protokoll", new System.IO.FileInfo(@"c:\temp\Protokoll.txt"));
   dateien.Add("Eingabe", new System.IO.FileInfo(@"c:\temp\Eingabe.txt"));
   dateien.Add("Ausgabe", new System.IO.FileInfo(@"c:\temp\"));

   System.Collections.Generic.List<Mann> MaennerClub = new System.Collections.Generic.List<Mann>();

   //  MaennerClub.Add(new Mann());
   //Fehler
   //MaennerClub.Add(new Frau());

   MaennerListe mliste2 = new MaennerListe();

  }

  class MenschenListe : System.Collections.Generic.LinkedList<Mensch>
  {

  }

  class MaennerListe : System.Collections.Generic.LinkedList<Mann>
  {

  }


 }
 #endregion
}
