Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text
Imports de.ITVisions.DemoViewer
Imports System.Data
Imports System.Data.Common
Imports System.Data.SqlClient
Imports de.WWWings.MiscDemos
Namespace NET2.ADONET
 <Demo()> _
 Friend Class Command

  ''' <summary>
  ''' SQL-Befehle in einer Transaktion ausfhren
  ''' Flge 313 und 192
  ''' </summary>
  Public Sub ADONET_Transaction_Demo()

   Demo.PrintHeader("Command-Transaction-Demo")
   Dim CONNSTRING As String = DemoConfig.CONNSTRING

   Const SQL1 As String = "INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " & "VALUES (1, 313, 500, 'F')"
   Const SQL2 As String = "INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " & "VALUES (1, 193, 500, 'F')" ' Erfolgreicher Befehl
   'const string SQL2 = @"INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_FlugDatum], [GF_Preis], [GF_Klasse]) " +
   ' "VALUES (1, 203, 8/1/2005, 500, 'FFF')"; // Zum Testen: Fehlerhafter Befehl
   Const SQL3 As String = "Select count(*) from GF_GebuchteFluege"
   ' Verbindung aufbauen
   Dim sqlConn As SqlConnection = New SqlConnection(CONNSTRING)
   sqlConn.Open()

   ' Befehlsobjekt erzeugen
   Dim sqlCmd As SqlCommand = sqlConn.CreateCommand()
   sqlCmd.CommandText = SQL3
   Demo.Print("Anzahl Datenstze vorher: " & sqlCmd.ExecuteScalar().ToString())
   Dim t As SqlTransaction = Nothing
   Try
    t = sqlConn.BeginTransaction()
    sqlCmd.CommandText = SQL1
    sqlCmd.Transaction = t
    Demo.Print(SQL1)
    Demo.Print("Betroffene Zeilen: " & sqlCmd.ExecuteNonQuery())
    sqlCmd.CommandText = SQL2
    sqlCmd.Transaction = t
    Demo.Print(SQL2)
    Demo.Print("Betroffene Zeilen: " & sqlCmd.ExecuteNonQuery())
    t.Commit()
    Demo.Print("Transaktion erfolgreich ausgefhrt!")
   Catch ex As Exception
    t.Rollback()
    Demo.Print("Transaktion fehlgeschlagen: " & ex.Message)
   Finally
    sqlCmd.CommandText = SQL3
    Demo.Print("Anzahl Datenstze nachher: " & sqlCmd.ExecuteScalar().ToString())
    sqlConn.Close()
   End Try
  End Sub

  ' === SQL-Befehle in einer Transaktion ausfhren unter Verwendung von Parametern
  Public Sub ADONET_Command_Parameters()

   Demo.PrintHeader("Command-Transaction-Demo mit Parametern")
   Dim CONNSTRING As String = DemoConfig.CONNSTRING

   Const SQL1 As String = "INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " & "VALUES (@PS, @FL, @Preis, @Klasse)"
   Const SQL2 As String = "INSERT INTO GF_GebuchteFluege ([GF_PS_ID], [GF_FL_FlugNr], [GF_Preis], [GF_Klasse]) " & "VALUES (@PS, @FL, @Preis, @Klasse)"
   Const SQL3 As String = "Select count(*) from GF_GebuchteFluege"
   ' Verbindung aufbauen
   Dim sqlConn As SqlConnection = New SqlConnection(CONNSTRING)
   sqlConn.Open()

   ' Befehlsobjekt erzeugen
   Dim sqlCmd As SqlCommand = sqlConn.CreateCommand()
   sqlCmd.CommandText = SQL3
   Demo.Print("Anzahl Datenstze vorher: " & sqlCmd.ExecuteScalar().ToString())
   Dim t As SqlTransaction = Nothing
   Try
    t = sqlConn.BeginTransaction()
    sqlCmd.CommandText = SQL1
    sqlCmd.Transaction = t
    sqlCmd.Parameters.AddWithValue("@PS", 1)
    sqlCmd.Parameters.AddWithValue("@FL", 600)
    sqlCmd.Parameters.AddWithValue("@Preis", 300)
    sqlCmd.Parameters.AddWithValue("@Klasse", "F")

    Demo.Print(SQL1)
    Demo.Print("Betroffene Zeilen: " & sqlCmd.ExecuteNonQuery())
    sqlCmd.CommandText = SQL2
    sqlCmd.Transaction = t

    sqlCmd.Parameters("@FL").Value = 601
    sqlCmd.Parameters("@Preis").Value = 240

    Demo.Print(SQL2)
    Demo.Print("Betroffene Zeilen: " & sqlCmd.ExecuteNonQuery())
    t.Commit()
    Demo.Print("Transaktion erfolgreich ausgefhrt!")
   Catch ex As Exception
    t.Rollback()
    Demo.Print("Transaktion fehlgeschlagen: " & ex.Message)
   Finally
    sqlCmd.CommandText = SQL3
    Demo.Print("Anzahl Datenstze nachher: " & sqlCmd.ExecuteScalar().ToString())
    sqlConn.Close()
   End Try
  End Sub
 End Class
End Namespace
