Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text
Imports de.ITVisions.DemoViewer
Imports System.Data
Imports System.Data.Common
Imports System.Data.SqlClient
Imports de.WWWings.MiscDemos

Namespace NET2.ADONET
 <Demo()> _
 Friend Class DataSetDemos

  ' Einlesen einer XML-Datei in einen DataSet
  Public Sub DataSet_LesenAusXmlDatei()
   Dim ds As DataSet = New DataSet()

   ds.ReadXml("c:\websites.xml")

   Demo.Print(ds.GetXmlSchema())


   For Each dt As DataTable In ds.Tables
    Demo.Print("Tabelle: " & dt.TableName + Constants.vbLf & "-------" & Constants.vbLf)
    For Each dr As DataRow In dt.Rows
     'string?[] s = dr.ItemArray as string?[];
     'Demo.Print(String.Join(";", s));
     For Each dc As DataColumn In dt.Columns
      Demo.Print((dr(dc.ColumnName)).ToString())
     Next dc
    Next dr

    For Each drel As DataRelation In ds.Relations
     Demo.Print(drel.RelationName)
    Next drel

    For Each dr As DataRow In ds.Tables("Website").Rows
     Demo.Print(dr("URL").ToString())

     For Each dr2 As DataRow In dr.GetChildRows("Website_Zugangsdaten")
      'foreach (DataRow dr3 in dr2.GetChildRows("Inhaber_Name"))
      '{
      ' 

      Demo.Print(" - Name: " & dr2(0).ToString())
      '}
     Next dr2

    Next dr

   Next dt


  End Sub

  ' === Daten lesen mit einem DataSet
  Public Sub DataSet_Lesen()
   Demo.PrintHeader("Datareader Demo")

   Dim CONNSTRING As String = DemoConfig.CONNSTRING
   Const SQL As String = "Select * from FL_Fluege"

   ' --- Verbindung aufbauen
   Dim conn As SqlConnection = New SqlConnection(CONNSTRING)
   conn.Open()
   ' --- Befehl ausfhren
   Dim cmd As SqlCommand = New SqlCommand(SQL, conn)
   ' --- Datenadapter erzeugen
   Dim da As SqlDataAdapter = New SqlDataAdapter(cmd)
   ' --- DataSet erzeugen
   Dim ds As DataSet = New DataSet()
   ' --- Daten abholen
   da.Fill(ds, "Flug")
   ' --- Verbindung jetzt schon schlieen!
   conn.Close()
   ' --- Zugriff auf die einzige Tabelle
   Dim dt As DataTable = ds.Tables("Flug")
   Demo.Print("Name der Tabelle: " & dt.TableName)
   ' --- Iteration ber Daten
   For Each dr As DataRow In dt.Rows
    Demo.Print("Flug-ID: " & dr("FL_FlugNr").ToString() & " von " & dr(1).ToString() & " nach " & dr(2).ToString())
   Next dr

   Demo.Print(ds.GetXmlSchema())
   Demo.Print(ds.GetXml())
   ds.WriteXml("c:\Fluege.xml", XmlWriteMode.WriteSchema)

   ' Datensicht definieren
   Demo.PrintHeader("Selektierte Daten:")
   Dim dv As DataView = New DataView(dt)
   dv.RowFilter = "FL_Abflugort = 'Paris'"
   dv.Sort = "FL_Zielort desc"
   ' --- Iteration ber Daten
   For Each drv As DataRowView In dv
    Dim dr As DataRow = drv.Row
    Demo.Print("Flug-ID: " & dr("FL_FlugNr").ToString() & " von " & dr(1).ToString() & " nach " & dr(2).ToString())
   Next drv
  End Sub

  ' === Daten verknpfen in einem DataSet
  Public Sub Dataset_Beziehungen()
   Demo.PrintHeader("Passagiere mit Ihren Flgen (Dataset-Beziehungen-Demo)")

   Dim CONNSTRING As String = DemoConfig.CONNSTRING
   Const SQL1 As String = "Select * from AllePassagiere"
   Const SQL2 As String = "Select * from GF_GebuchteFluege"

   ' --- Verbindung aufbauen
   Dim conn As SqlConnection = New SqlConnection(CONNSTRING)
   conn.Open()
   ' --- Leeres DataSet erzeugen
   Dim ds As DataSet = New DataSet()
   ' --- Datenadapter erzeugen
   Dim da1 As SqlDataAdapter = New SqlDataAdapter(SQL1, CONNSTRING)
   Dim da2 As SqlDataAdapter = New SqlDataAdapter(SQL2, CONNSTRING)
   ' --- Daten abholen
   da1.Fill(ds, "AllePassagiere")
   da2.Fill(ds, "GebuchteFluege")
   ' --- Verbindung jetzt schon schlieen!
   conn.Close()
   ' --- Verknpfung herstellen
   Dim dc1 As DataColumn = ds.Tables("AllePassagiere").Columns("PS_ID")
   Dim dc2 As DataColumn = ds.Tables("GebuchteFluege").Columns("GF_PS_ID")
   Dim drel As DataRelation = New DataRelation("Passagiere_GebuchteFluege", dc1, dc2)
   ds.Relations.Add(drel)

   ' --- Zugriff auf Tabelle Websites
   Dim dt As DataTable = ds.Tables("AllePassagiere")
   ' --- Iteration ber Daten
   For Each dr As DataRow In dt.Rows
    Demo.Print("Name: " & dr("PE_Name").ToString() & " Vorname: " & dr("PE_Vorname").ToString())
    For Each dr2 As DataRow In dr.GetChildRows(drel)
     Demo.Print("  Flug: " & dr2("GF_FL_FlugNr").ToString() & " Preis: " & dr2("GF_Preis").ToString())
    Next dr2
   Next dr
  End Sub
 End Class
End Namespace
