Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text
Imports de.ITVisions.DemoViewer
Imports System.Data
Imports System.Data.Common
Imports System.Data.SqlClient
Imports de.WWWings.MiscDemos
Namespace NET2.ADONET
 <Demo()> _
 Friend Class DataSetDemos_Schreiben

  ' === Daten schreiben mit einem DataSet
  Public Sub run()
   Demo.PrintHeader("DataSet: Daten ndern")

   Dim CONNSTRING As String = DemoConfig.CONNSTRING
   Const SQL As String = "Select * from FL_Fluege"

   ' --- Verbindung aufbauen
   Dim conn As SqlConnection = New SqlConnection(CONNSTRING)
   conn.Open()
   ' --- Befehl ausfhren
   Dim cmd As SqlCommand = New SqlCommand(SQL, conn)
   ' --- Datenadapter erzeugen
   Dim da As SqlDataAdapter = New SqlDataAdapter(cmd)
   ' --- DataSet erzeugen
   Dim ds As DataSet = New DataSet()
   ' --- Daten abholen
   da.Fill(ds)
   ' --- Verbindung jetzt schon schlieen!
   conn.Close()

   Dim dt As DataTable = ds.Tables(0)

   ' --- Datenstze lschen
   For Each dr2 As DataRow In dt.Rows
    If dr2("FL_AbflugOrt").ToString() = "Essen/Mlheim" Then
     Demo.Print("Lsche: " & dr2("FL_FlugNr").ToString())
     dr2.Delete()
    End If
   Next dr2

   ' --- Datenstze ndern
   For Each dr2 As DataRow In dt.Rows
    If dr2.RowState <> DataRowState.Deleted Then
     If TypeOf dr2("FL_AnzahlStarts") Is System.DBNull Then
      dr2("FL_AnzahlStarts") = Convert.ToInt32(dr2("FL_AnzahlStarts")) + 1
     Else
      dr2("FL_AnzahlStarts") = 1
     End If
     Demo.Print("Counter erhht fr: " & dr2("FL_FlugNr").ToString())
    End If
   Next dr2

   ' --- Datenstz anfgen
   Dim dr As DataRow = dt.NewRow()
   dr("FL_FlugNr") = "123"
   dr("FL_AnzahlStarts") = 0
   dr("FL_EingerichtetAm") = DateTime.Now
   dr("FL_Abflugort") = "Essen/Mlheim"
   dr("FL_Zielort") = "Eichsttt"
   dt.Rows.Add(dr)

   ' --- Statistik
   If ds.HasChanges(DataRowState.Added) Then
    Demo.Print("Anzahl der hinzugefgten Datenstze: " & dt.GetChanges(DataRowState.Added).Rows.Count)
   End If
   If ds.HasChanges(DataRowState.Modified) Then
    Demo.Print("Anzahl der genderten Datenstze: " & dt.GetChanges(DataRowState.Modified).Rows.Count)
   End If
   If ds.HasChanges(DataRowState.Deleted) Then
    Demo.Print("Anzahl der gelschten Datenstze: " & dt.GetChanges(DataRowState.Deleted).Rows.Count)
   End If

   ' --- Befehle fr Datenadapter erzeugen
   Dim cb As SqlCommandBuilder = New SqlCommandBuilder(da)
   ' --- Kontrollausgabe
   Demo.Print("Erzeugte SQL DML-Befehle:")
   Demo.Print("UPDATE: " & cb.GetUpdateCommand().CommandText)
   Demo.Print("DELETE: " & cb.GetDeleteCommand().CommandText)
   Demo.Print("INSERT: " & cb.GetInsertCommand().CommandText)

   ' --- Aktualisieren
   da.Update(ds.Tables(0))
   Demo.Print("Daten wurden aktualisiert!")


  End Sub


 End Class
End Namespace
