#Region "   Using    directives"


Imports Microsoft.VisualBasic
Imports System
Imports System.Collections.Generic
Imports System.Text

#End Region

' .NET Framework 2.0 Demos
' (C) Dr. Holger Schwichtenberg
' http://www.dotnetframework.de
' =====================================
Imports de.ITVisions.DemoViewer
Imports System.Data
Imports System.Data.Common
Imports System.Data.SqlClient
Imports de.WWWings.MiscDemos
Imports System.Data.OleDb

Namespace NET2.ADONET
 ''' <summary>
 ''' Summary description for ProviderEnum.
 ''' </summary>
 <Demo> _
 Public Class BulkImport

  '  <System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1707:IdentifiersShouldNotContainUnderscores", MessageId:="Member")> _

  ' Massenkopie zwischen SQL Server-Datenbanken ohne Optionen
  Public Sub run_SQLtoSQL_Einfach()
   Demo.PrintHeader("Bulk Copy - SQL Server->SQL Server - Einfach")
   Dim CS_Quelle As String = DemoConfig.CONNSTRING
   Dim CS_Ziel As String = DemoConfig.CONNSTRING
   Const SQL_Quelle As String = "select * from FL_Fluege"
   Const ZIELTABELLE As String = "FLB_Fluege_Backup"

   ' Aufrumen!
   'DE.ITVisions.SADO.Execute("Provider=SQLOLEDB;"+CS_Ziel, "Delete from FL_Fluege_Backup");

   ' Verbindung zur Quelle
   Demo.Print("Verbindung zur Quelle ffnen...")
   Dim C_Quelle As SqlConnection = New SqlConnection(CS_Quelle)
   C_Quelle.Open()
   ' Verbindung zum Ziel
   Demo.Print("Verbindung im Ziel ffnen...")
   Dim C_Ziel As SqlConnection = New SqlConnection(CS_Ziel)
   C_Ziel.Open()

   ' Daten holen
   Demo.Print("Daten aus Quelle einlesen...")
   Dim CMD_Quelle As SqlCommand = New SqlCommand(SQL_Quelle, C_Quelle)
   Dim Reader As SqlDataReader = CMD_Quelle.ExecuteReader()

   ' Kopiervorgang
   Demo.Print("Daten in Zieltabelle schreiben...")
   Dim BulkCopy As SqlBulkCopy = New SqlBulkCopy(C_Ziel)
   BulkCopy.DestinationTableName = ZIELTABELLE
   BulkCopy.WriteToServer(Reader)

   ' Ende
   Reader.Close()
   C_Quelle.Close()
   C_Ziel.Close()
  End Sub


  ' Massenkopie von Access-Datenbank in SQL Server-Datenbank
  Public Sub run_AccessToSQL()
   Demo.PrintHeader("Bulk Copy - Access->SQL Server - Einfach")
   Const CS_Quelle As String = "Provider='Microsoft.Jet.OLEDB.4.0';Data Source='E:\N2C\WorldWideWings\Datenbanken\WorldWideWings.mdb'"
   Dim CS_Ziel As String = DemoConfig.CONNSTRING
   Const SQL_Quelle As String = "select * from FL_Fluege"
   Const ZIELTABELLE As String = "FLB_Fluege_Backup"

   ' Aufrumen!
   ' DE.ITVisions.SADO.Execute("Provider=SQLOLEDB;" + CS_Ziel, "Delete from FL_Fluege_Backup");

   ' Verbindung zur Quelle
   Demo.Print("Verbindung zur Quelle ffnen...")
   Dim C_Quelle As OleDbConnection = New OleDbConnection(CS_Quelle)
   C_Quelle.Open()
   ' Verbindung zum Ziel
   Demo.Print("Verbindung im Ziel ffnen...")
   Dim C_Ziel As SqlConnection = New SqlConnection(CS_Ziel)
   C_Ziel.Open()

   ' Daten holen
   Demo.Print("Daten aus Quelle einlesen...")
   Dim CMD_Quelle As OleDbCommand = New OleDbCommand(SQL_Quelle, C_Quelle)
   Dim Reader As OleDbDataReader = CMD_Quelle.ExecuteReader()

   ' Kopiervorgang
   Demo.Print("Daten in Zieltabelle schreiben...")
   Dim BulkCopy As SqlBulkCopy = New SqlBulkCopy(C_Ziel)
   BulkCopy.DestinationTableName = ZIELTABELLE
   BulkCopy.WriteToServer(Reader)

   ' Ende
   Reader.Close()
   C_Quelle.Close()
   C_Ziel.Close()
  End Sub

  ' Massenkopie zwischen SQL Server-Datenbanken mit Optionen
  Public Sub SQLToSQL_Erweitert()

   Demo.PrintHeader("Bulk Copy - SQL Server->SQL Server - Erweitert")

   Dim CS_Quelle As String = DemoConfig.CONNSTRING
   Dim CS_Ziel As String = DemoConfig.CONNSTRING
   Const SQL_Quelle As String = "select * from FL_Fluege"
   Const ZIELTABELLE As String = "FLB_Fluege_Backup"

   ' Verbindung zur Quelle
   Demo.Print("Verbindung zur Quelle ffnen...")
   Dim C_Quelle As SqlConnection = New SqlConnection(CS_Quelle)
   C_Quelle.Open()
   ' Verbindung zum Ziel
   Demo.Print("Verbindung im Ziel ffnen...")
   Dim C_Ziel As SqlConnection = New SqlConnection(CS_Ziel)
   C_Ziel.Open()

   ' Daten holen
   Demo.Print("Daten aus Quelle einlesen...")
   Dim CMD_Quelle As SqlCommand = New SqlCommand(SQL_Quelle, C_Quelle)
   Dim Reader As SqlDataReader = CMD_Quelle.ExecuteReader()

   ' Kopiervorgang
   Demo.Print("Daten in Zieltabelle schreiben...")
   Dim BulkCopy As SqlBulkCopy = New SqlBulkCopy(C_Ziel)
   BulkCopy.DestinationTableName = ZIELTABELLE

   BulkCopy.ColumnMappings.Add("FL_Abflugort", "FL_ZielOrt")
   BulkCopy.ColumnMappings.Add("FL_ZielOrt", "FL_Abflugort")
   BulkCopy.NotifyAfter = 200
   AddHandler BulkCopy.SqlRowsCopied, AddressOf BulkCopy_SqlRowsCopied
   BulkCopy.WriteToServer(Reader)

   ' Ende
   Reader.Close()
   C_Quelle.Close()
   C_Ziel.Close()

  End Sub

  ' Ereignisbehandlung
  Private Shared Sub BulkCopy_SqlRowsCopied(ByVal sender As Object, ByVal e As SqlRowsCopiedEventArgs)
   Demo.Print("Zeile kopiert: " & e.RowsCopied)
  End Sub
 End Class
End Namespace

' Add.ons:
'  Demo.Print("Datenstze im Ziel vorher: " + DE.ITVisions.SADO.GetTable("Provider=SQLOLEDB;" + CS_Ziel, "Select *from FL_Fluege_Backup").Rows.Count);
