' .NET Framework 2.0 Demos
' (C) Dr. Holger Schwichtenberg
' http://www.dotnetframework.de
' =====================================


Imports Microsoft.VisualBasic
Imports System
Imports System.Data
Imports System.Data.Common
Imports de.ITVisions.DemoViewer
Imports de.WWWings.MiscDemos
Namespace NET2.ADONET
 ''' <summary>
 ''' Summary description for Factory.
 ''' </summary>
 <Demo()> _
 Public Class FactoryDemo
  Public Sub run()
   Demo.PrintHeader("DEMO Provider Factory")
   Const PROVIDER As String = "System.Data.SqlClient"
   Dim CONNSTRING As String = DemoConfig.CONNSTRING
   Const SQL As String = "Select * from FL_Fluege"

   ' --- Factory erzeugen
   Dim factory As DbProviderFactory = DbProviderFactories.GetFactory(PROVIDER)
   ' --- Verbindung aufbauen
   Dim conn As DbConnection = factory.CreateConnection()
   conn.ConnectionString = CONNSTRING
   conn.Open()

   ' --- Teil 1: DataReader
   ' Befehl erzeugen
   ' frher: System.Data.SqlClient.SqlCommand = new System.Data.SqlClient.SqlCommand();
   Dim cmd As DbCommand = factory.CreateCommand()
   cmd.CommandText = SQL
   cmd.Connection = conn

   ' Befehl ausfhren
   Dim reader As DbDataReader = cmd.ExecuteReader()
   ' Daten ausgeben
   Demo.PrintReader(reader)
   reader.Close()

   ' --- Teil 2: DataSet
   ' Befehl erzeugen
   Dim command As DbCommand = factory.CreateCommand()
   command.CommandText = SQL
   command.Connection = conn
   ' DataAdapter erzeugen
   Dim adapter As DbDataAdapter = factory.CreateDataAdapter()
   adapter.SelectCommand = command
   ' DataSet erzeugen
   Dim ds As DataSet = New DataSet()
   ' DataSet befllen
   adapter.Fill(ds)
   ' Daten ausgeben
   Dim t As DataTable = ds.Tables(0)
   Console.WriteLine("Anzahl Spalten: " & t.Columns.Count)
   Console.WriteLine("Anzahl Zeilen: " & t.Rows.Count)
   conn.Close()
  End Sub
 End Class
End Namespace
