Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Windows.Forms
Imports de.ITVisions.DemoViewer

Namespace NET2.FCL

 <Demo> _
 Public Class Dateisystem


	<FCL2> _
	Public Sub Laufwerke_Auflisten()
	For Each di As DriveInfo In DriveInfo.GetDrives()
	 Demo.Print("Laufwerk: " & di.Name)
	 If di.IsReady Then
	  Demo.Print("  Bezeichnung: " & di.VolumeLabel)
	  Demo.Print("  Typ: " & di.DriveType)
	  Demo.Print("  Format: " & di.DriveFormat)
	  Demo.Print("  Gre: " & di.TotalSize)
	  Demo.Print("  Freier Platz: " & di.TotalFreeSpace)
	  Demo.Print("  Wurzelordner: " & di.RootDirectory.FullName)
	 Else
	  Demo.Print("  ist nicht bereit!")
	 End If
	Next di

	End Sub


   Public Sub Sonderverzeichnisse()
	Demo.Print(Microsoft.VisualBasic.FileIO.SpecialDirectories.MyDocuments)
	Demo.Print(Microsoft.VisualBasic.FileIO.SpecialDirectories.Desktop)
	Demo.Print(Microsoft.VisualBasic.FileIO.SpecialDirectories.CurrentUserApplicationData)
	Demo.Print(Microsoft.VisualBasic.FileIO.SpecialDirectories.Programs)
   End Sub


	Public Sub Dateien_Erzeugen()

	  ' Erzeugen und Lschen von Textdateien
	 Dim verzeichnis As String = "..\..\_daten\dateisystem\"

	  ' Zugriff auf ein Dateiverzeichnis
	  Dim d As DirectoryInfo = New DirectoryInfo(verzeichnis)

	  ' 10 neue Dateien erzeugen
	  For i As Integer = 0 To 9
		Dim dateiname As String = "Datei" & (i+1).ToString() & ".txt"
		Dim fi As FileInfo = New FileInfo(d.FullName & "\" & dateiname)
		If fi.Exists Then
		  ' Wenn Datei vorhanden, dann lschen!
		  fi.Delete()
		  Demo.Print("Datei " & dateiname & " gelscht!")
		End If
		fi.Create()
		Demo.Print("Datei " & fi.Name & " erzeugt!")
	  Next i
	End Sub

   <UPDATE("8.12.03")> _
   Public Sub Datei_Liste()
	  ' Liste der Dateien in einem bestimmten Ordner
	  Dim verzeichnis As String = Directory.GetCurrentDirectory() & "\_daten\dateisystem\"

	  ' Zugriff auf ein Dateiverzeichnis
	  Dim d As DirectoryInfo = New DirectoryInfo(verzeichnis)

	  ' Prfung auf Existenz des Verzeichnisses
	  If (Not d.Exists) Then
		Demo.Print("Verzeichnis nicht vorhanden!")
		Return
	  End If

	  ' Ausgabe von Informationen ber den Ordner
	  Demo.Print("Erzeugt am: " & d.CreationTime)
	  Demo.Print("Zuletzt gelesen am : " & d.LastAccessTime)
	  Demo.Print("Zuletzt gendert am : " & d.LastWriteTime)
	  Demo.Print("Wurzelordner: " & d.Root.Name)
	  Demo.Print("Name des bergeordneten Ordners: " & d.Parent.Name)
	  Demo.Print("Pfad des bergeordneten Ordners: " & d.Parent.FullName)

	  ' Liste alle  Textdateien in diesem Verzeichnis
	  Demo.Print("Alle Text-Dateien in Ordner: " & d.FullName)
	  For Each f As FileInfo In d.GetFiles("*.txt")
		Demo.Print(f.Name & ";" & f.Length & ";" & f.CreationTime)
	  Next f
   End Sub

	Public Sub Datei_Jonglieren()

	 Dim quelle As String = "..\..\_daten\dateisystem\"
	 Dim ziel1 As String = "..\..\_daten\dateisystem1\"

	  ' Zugriff auf ein Dateiverzeichnis
	  Dim d As DirectoryInfo = New DirectoryInfo(quelle)

	  ' Bewegen des Verzeichnisses
	  d.MoveTo(ziel1)

	End Sub

	Public Sub Datei_Makedir1()

	  ' Verzeichnisse anlegen und lschen
	 Dim verzeichnis As String = "..\..\_daten\dateisystem\hs\Dokumente\"

	  ' Zugriff auf ein Dateiverzeichnis
	  Dim d As DirectoryInfo = New DirectoryInfo(verzeichnis)
	  ' Verzeichnis erzeugen
	  d.Create()

	  ' Unterverzeichnis erzeugen
	  Dim sd As DirectoryInfo = d.CreateSubdirectory("1. Halbjahr")
	  Demo.Print(sd.FullName & " angelegt!")

	  ' Unterverzeichnis erzeugen
	  sd = d.CreateSubdirectory("2. Halbjahr")
	  Demo.Print(sd.FullName & " angelegt!")

	  MessageBox.Show("Ordner angelegt!")

	  ' Verzeichniss rekursiv wieder lschen
	  d.Delete(True)
	End Sub

	Public Sub Datei_Makedir2()

	  ' Verzeichnis anlegen (VARIANTE)
	 Dim verzeichnis As String = "..\..\_daten\dateisystem\hs\Dokumente\"

	  ' Verzeichnis anlegen
	  Directory.CreateDirectory(verzeichnis)
	  MessageBox.Show("Ordner angelegt!")
	  ' Verzeichniss  wieder lschen
	  Directory.Delete(verzeichnis, True)
	End Sub


	Public Sub Datei_Bewegen()

	  ' Datei kopieren und verschieben
	 Dim docOrdner As String = "..\..\_daten\dateisystem\Dokumente\"

	  If Directory.Exists(docOrdner) Then
		Directory.Delete(docOrdner, True)
	  End If

	  Directory.CreateDirectory(docOrdner)

	  Demo.Print("Ordner angelegt!")

	  File.Copy("..\..\_daten\dateisystem\buch.doc", docOrdner & Constants.vbBack & "uch.doc")
	  Demo.Print("Datei kopiert!")

	  File.Delete("..\..\_daten\dateisystem\buch.doc")
	  Demo.Print("Ausgangsdatei gelscht")

	  File.Move(docOrdner & "buch.doc", "..\..\_daten\dateisystem\buch.doc")
	  Demo.Print("Kopie verschoben")

	  Directory.Delete(docOrdner, True)
	  Demo.Print("Verzeichnis gelscht")
	End Sub
 End Class
End Namespace
