Imports Microsoft.VisualBasic
Imports System
Imports System.IO
Imports System.Threading
Imports System.Diagnostics
Imports System.Windows.Forms
Imports de.ITVisions.DemoViewer

Namespace NET2.FCL

 <Demo> _
 Public Class Ereignisprotokolle


  Public Sub Ereignisprotokoll_Auflisten()
   ' Liste der Ereignisprotokolle auf einem bestimmten Computer
   Dim computer As String = "E"

   Demo.Print("Liste der EventLogs auf dem Computer " & computer)
   Dim liste As EventLog() = EventLog.GetEventLogs(computer)

   For Each e As EventLog In liste
	Demo.Print(e.Log)
   Next e
  End Sub


  ' Erzeugung eines neuen Eintrags in einem Ereignisprotokoll
  Public Sub EreignisprotokollEintrag_Schreiben()

   Dim logname As String = "N2C-B5"
   Dim source As String = "N2C-StartStop5"
   Dim computer As String = "Essen"
   ' Quelle und ggf. Ereignisprotokoll anlegen
   If (Not EventLog.SourceExists(source, computer)) Then
	Dim escd As EventSourceCreationData = New EventSourceCreationData(source, logname)
	escd.MachineName = computer
	escd.LogName = logname
	EventLog.CreateEventSource(escd)
	Demo.Print("Quelle angelegt!")
   End If
   ' Eintrag schreiben
   EventLog.WriteEntry(source, "Anwendung gestartet", EventLogEntryType.Information, 1234)
   ' Bildschirmausgabe
   Demo.Print("Eintrag geschrieben!")
  End Sub


  ' Auslesen von Eintrgen aus einem Ereignisprotokoll
  Public Sub EreignisprotokollEintraege_Lesen()
   ' Name des Ereignisprotokolls
   Dim logname As String = "Application"
   ' Anzahl der auszugebenden Eintrge
   Dim anzahl As Long = 10
   ' Zhler
   Dim count As Long = 0
   ' -- Zugriff auf das Ereignisprotokoll
   Dim log As EventLog = New EventLog(logname)

   Demo.Print("Letzte " & anzahl.ToString() & " Eintrge von " & log.Entries.Count & " Eintrgen aus dem Protokoll " & log.Log & " auf dem Computer " & log.MachineName)

   ' Schleife ber alle Eintrge
   For Each eintrag As EventLogEntry In log.Entries
	count += 1
	If count > log.Entries.Count - anzahl Then
	 Demo.Print(eintrag.EntryType & ":" & eintrag.InstanceId & ":" & eintrag.Category & ":" & eintrag.Message & ":" & eintrag.Source & ":" & eintrag.TimeGenerated & ":" & eintrag.TimeWritten & ":" & eintrag.UserName & ":")
	End If
   Next eintrag
  End Sub

  Public Sub Ereignisprotokoll_Loeschen()

   ' Lschen eines Ereignisprotokolls
   Dim logName As String = "Application"
   Dim computer As String = "Essen"

   ' Protokoll lschen
   EventLog.Delete(logName, computer)
   Demo.Print("Log gelscht!")
  End Sub

  Public Sub EventLog_Watcher()

   ' berwachung eines Ereignisprotokolls
   ' Instanziierung und Konfiguration
   Dim log As EventLog = New EventLog()
   log.Log = "Application"
   log.MachineName = "Essen"

   ' Verbindung der Ereignisbehandlungsroutine
   AddHandler log.EntryWritten, AddressOf EventLog_NeuerEintrag

   ' Starten der berwachung
   log.EnableRaisingEvents = True

   Thread.Sleep(5000)
   Me.EreignisprotokollEintrag_Schreiben()

   ' Warten auf Benutzeraktion
   MessageBox.Show("Klicken Sie hier, um die berwachung zu beenden!", "berwachung")
  End Sub


  Private Sub EventLog_NeuerEintrag(ByVal source As Object, ByVal e As EntryWrittenEventArgs)

   '  Ereignisbehandlungsroutine fr Event-Log-berwachung
   Dim eintrag As EventLogEntry = e.Entry

   Demo.Print(eintrag.EntryType.ToString() & ":" & eintrag.InstanceId.ToString() & ":" & eintrag.Category & ":" & eintrag.Message & ":" & eintrag.Source & ":" & eintrag.TimeGenerated.ToShortTimeString() & ":" & eintrag.TimeWritten.ToShortTimeString() & ":" & eintrag.UserName)
  End Sub
 End Class
End Namespace
