Imports Microsoft.VisualBasic
Imports System
Imports System.DirectoryServices
Imports ActiveDs
Imports de.ITVisions.DemoViewer

' Autor: Dr. Holger Schwichtenberg, http://www.IT-Visions.de
' Hinweis: Ersetzen Sie demo.print durch eine Ausgabefunktion ihrer Wahl oder laden Sie das Gesamtprojekt herunter unter
' http://www.IT-Visions.de/WWWings

' Achtung: "Hochzhlen" der Attributnamen ist Work-Around zum Testen, weil Lschen von Schemamodifikationen nicht mehr mglich ist

Namespace Demos.NET2.FCL


 Class Verzeichnisdienste_ADS_Schema

  Const ADS_PROPERTY_APPEND As Integer = 3
  Const DS_INSTANCETYPE_NC_IS_WRITEABLE As Integer = 4
  Dim Counter As Long = 0

  Function DeactivateSchemaObject(ByVal strSchemaNamingContext As String, ByVal Name As String) As DirectoryEntry
   Dim objAtt As DirectoryEntry = Nothing
   Try
    Demo.Print("Suche Schema-Objekt: " & Name)
    Dim de As New DirectoryEntry(strSchemaNamingContext)
    objAtt = de.Children.Find("cn=" & Name)
   Catch ex As Exception : End Try
   If Not objAtt Is Nothing Then
    Try
     objAtt.Properties("isDefunct").Add(True)
     objAtt.CommitChanges()
     Demo.Print("Schema-Objekt deaktiviert: " & Name)
    Catch ex As Exception
    End Try
   End If
   Return objAtt
  End Function

  Sub AttributAnlegen(ByVal objRoot As ActiveDs.IADs, ByVal objSchema As ActiveDs.IADs, ByVal strSchemaNamingContext As String, ByRef strAttributeName As String, ByVal ID As Long)
   Dim objNewAttribute As ActiveDs.IADs
   Dim strCNAttributeName As String
   Dim AttrName As String
   Counter = 0
   ' === Sicherstellen, dass es keine Attribute mit diesem Namen mehr gibt
   Dim objAtt As DirectoryEntry = Nothing
   Do
    Counter += 1
    AttrName = strAttributeName & Counter
    strCNAttributeName = "CN=" & AttrName
    objAtt = CType(DeactivateSchemaObject(objSchema.ADsPath, AttrName), DirectoryEntry)
   Loop While Not objAtt Is Nothing

   objNewAttribute = CType(objSchema.Create("attributeSchema", strCNAttributeName), IADs)
   Dim AttID As String = "1.2.840.113556.1.4." & ID & "." & Counter

   Demo.Print("Attribut anlegen: " + AttrName + " (" + AttID + ") ")
   ' String 2.5.5.5 / 19
   ' Int 2.5.5.9 / 2
   ' Basiswerte
   objNewAttribute.Put("attributeID", AttID)
   objNewAttribute.Put("oMSyntax", 2)
   objNewAttribute.Put("attributeSyntax", "2.5.5.9")
   objNewAttribute.Put("isSingleValued", True)

   ' Weitere Werte
   'objNewAttribute.Put("instanceType", DS_INSTANCETYPE_NC_IS_WRITEABLE)
   'objNewAttribute.Put("attributeID", "2.2.840.113556.1.4.265")
   'objNewAttribute.Put("attributeID", "1.2.840.113556.1.4.265")
   'objNewAttribute.Put("rangeUpper", 32768)
   'objNewAttribute.Put("showInAdvancedViewOnly", True)
   'objNewAttribute.Put("adminDisplayName", strAttributeName)
   'objNewAttribute.Put("adminDescription", strAttributeName)
   'objNewAttribute.Put("searchFlags", 0)
   'objNewAttribute.Put("lDAPDisplayName", strAttributeName)
   'objNewAttribute.Put("name", strAttributeName)
   'objNewAttribute.Put("systemOnly", False)
   'objNewAttribute.Put("systemFlags", 16)
   'objNewAttribute.Put("objectCategory", "CN=Attribute-Schema," & strSchemaNamingContext)
   objNewAttribute.SetInfo()

   Demo.Print("Attribut erzeugt: " & objNewAttribute.Name)

   ' Update schema cache.

   objRoot.Put("schemaUpdateNow", 1)
   objRoot.SetInfo()
   strAttributeName = AttrName
   Demo.Print("Schema aktualisiert!")
  End Sub

  Sub ADS_AttributeAnlegen()
   ' Global declarations.

   Dim strAttributeName1 As String = "Planet"
   Dim strAttributeName2 As String = "Universum"
   Dim objRoot As IADs
   Dim objSchema As IADs
   Dim strSchemaNamingContext As String  ' Schema DN.

   ' === Pfade zum Schema ermitteln
   objRoot = CType(New DirectoryEntry("LDAP://xfilesserver/RootDSE").NativeObject, IADs)
   strSchemaNamingContext = objRoot.Get("schemaNamingContext").ToString()
   objSchema = CType(New DirectoryEntry("LDAP://xfilesserver/" & strSchemaNamingContext).NativeObject, IADs)

   Demo.Print("Schema: " & objSchema.ADsPath)

   '======== 1. Attribut
   AttributAnlegen(objRoot, objSchema, strSchemaNamingContext, strAttributeName1, 7002)

   '======== 2. Attribut
   AttributAnlegen(objRoot, objSchema, strSchemaNamingContext, strAttributeName2, 7003)

  End Sub

  Sub ADS_KlasseAnlegen()

   Dim AlienCounter As Long = 4
   Dim strClassName As String = "Alien" & AlienCounter
   Dim strAttributeName1 As String = "Planet10"
   Dim strAttributeName2 As String = "Universum8"
   Dim objRoot As IADs
   Dim objSchema As IADs
   Dim strSchemaNamingContext As String  ' Schema DN.

   ' === Pfade zum Schema ermitteln
   objRoot = CType(New DirectoryEntry("LDAP://xfilesserver/RootDSE").NativeObject, IADs)
   strSchemaNamingContext = objRoot.Get("schemaNamingContext").ToString
   objSchema = CType(New DirectoryEntry("LDAP://xfilesserver/" & strSchemaNamingContext).NativeObject, IADs)

   Demo.Print("Schema: " & objSchema.ADsPath)

   ' === Neue Klasse

   Dim objNewClass As IADs               ' New class.
   Dim strCNClassName As String              ' Class CN.

   ' Create new class.
   strCNClassName = "CN=" & strClassName
   objNewClass = CType(objSchema.Create("classSchema", strCNClassName), IADs)

   ' Set selected values for class.
   objNewClass.Put("instanceType", DS_INSTANCETYPE_NC_IS_WRITEABLE)
   objNewClass.Put("subClassOf", "contact")
   objNewClass.Put("governsID", "1.2.840.113556.1.5.8000." & (100 + AlienCounter))
   objNewClass.Put("rDNAttID", "cn")
   objNewClass.Put("showInAdvancedViewOnly", True)
   objNewClass.Put("adminDisplayName", strClassName)
   objNewClass.Put("adminDescription", strClassName)
   objNewClass.Put("objectClassCategory", 1)
   objNewClass.Put("lDAPDisplayName", strClassName)
   objNewClass.Put("name", strClassName)
   objNewClass.Put("systemOnly", False)
   ' objNewClass.PutEx(ADS_PROPERTY_APPEND, _
   '             "systemPossSuperiors", "organizationalUnit")
   'objNewClass.Put("systemMayContain", strAttributeName)
   objNewClass.PutEx(ADS_PROPERTY_APPEND, "mayContain", New Object() {strAttributeName1, strAttributeName2})

   objNewClass.Put("systemMustContain", "cn")
   objNewClass.Put("defaultSecurityDescriptor", _
                   "D:(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;DA)" & _
                   "(A;;RPWPCRCCDCLCLORCWOWDSDDTSW;;;SY)" & _
                   "(A;;RPLCLORC;;;AU)")
   objNewClass.Put("systemFlags", 16)
   objNewClass.Put("defaultHidingValue", False)
   objNewClass.Put("objectCategory", "CN=Class-Schema," & strSchemaNamingContext)
   objNewClass.Put("defaultObjectCategory", "CN=Person," & strSchemaNamingContext)
   objNewClass.SetInfo()
   Demo.Print("Klasse angelegt: " & objNewClass.Name)


   objRoot.Put("schemaUpdateNow", 1)
   objRoot.SetInfo()
   Demo.Print("Schema aktualisiert!")
  End Sub

  Sub ADS_Alien_MassenAnlegen()
   Const LDAP_OU As String = "LDAP://xfilesserver/OU=Aliens,DC=FBI,DC=net"

   Dim start As DateTime = DateTime.Now
   For a As Integer = 1 To 100
    Dim zahl As String = String.Format("{0:0000}", a)
    Dim name As String = "Alien" & zahl
    Dim Planet As Integer = a Mod 10
    Dim Universum As Integer = a Mod 50
    Demo.PrintHeader(name)
    ADS_Alien_Anlegen(LDAP_OU, name, Planet, Universum)
   Next
   Dim ende As DateTime = DateTime.Now
   Demo.Print("Dauer in Sekunden: " & (ende - start).Seconds)
  End Sub

  Sub ADS_Alien_Anlegen(ByVal LDAP_OU As String, ByVal name As String, ByVal Planet As Integer, ByVal Universum As Integer)
   '  Anlegen eines User-Objects im Active Directory
   Demo.Print("# Anlegen des Aliens: " & name)
   ' Zugriff auf IADS
   Dim ou As DirectoryEntry = New DirectoryEntry(LDAP_OU)
   ' Zugriff auf IADSContainer
   Dim c As DirectoryEntries = ou.Children
   ' Neues Objekt erzeugen
   Dim u As DirectoryEntry = Nothing
   Try
    u = c.Find("cn=" & name)
   Catch ex As Exception : End Try
   If Not u Is Nothing Then
    Demo.Print("Alien existiert schon und wird daher gelscht!")
    c.Remove(u)
   End If
   u = c.Add("cn=" & name, "Alien4")
   ' Verzeichnisattribute festlegen
   u.Properties("Planet10").Add(Planet)
   u.Properties("Universum8").Add(Universum)
   ' nderungen speichern
   u.CommitChanges()
   Demo.Print("Alien wurde angelegt!")
  End Sub


 End Class
End Namespace