Imports Microsoft.VisualBasic
Imports System
Imports System.Management
Imports de.ITVisions.DemoViewer

Namespace NET2.FCL

 <Demo> _
 Public Class WMI

  ' Informationen ber ein Betriebssystem und Reboot 
  Public Sub WMI_Computer_Reboot()
   Const COMPUTER As String = "E45"
   ' Zugriff auf Klasse
   Dim mc As ManagementClass = New ManagementClass("\\" & COMPUTER & "\root\CIMV2:Win32_OperatingSystem")
   ' Instanzen holen
   Dim menge As ManagementObjectCollection = mc.GetInstances()
   ' Es gibt zwar nur ein Objekt, aber man kann nicht direkt darauf zugreifen
   For Each mo As ManagementObject In menge
	Demo.Print("Informationen ber das Betriebssystem auf: " & mo.Path.Server)
	Demo.Print("Name: " & mo("Name").ToString())
	Demo.Print("Hersteller: " & mo("Manufacturer").ToString())
	Demo.Print("Typ: " & mo("OSType").ToString())
	Demo.Print("Sprache: " & mo("OSLanguage").ToString())
	Demo.Print("Version: " & mo("Version").ToString())
	Demo.Print("Systemverzeichnis: " & mo("SystemDirectory").ToString())
	Demo.Print("Registrierter Benutzer: " & mo("RegisteredUser").ToString())
	Demo.PrintSubHeader("Reboot wird initiert...")
	mo.InvokeMethod("reboot", Nothing)
	Demo.PrintSubHeader("Reboot eingeleitet!")
   Next mo
  End Sub

  ' Auslesen von Daten ber Laufwerk C
  Public Sub WMI_Laufwerk_Auslesen()
   ' WMI-Pfad
   Const pfad As String = "\root\cimv2:Win32_LogicalDisk.DeviceID='C:'"

   ' Zugriff auf Managed Object
   Dim mo As ManagementObject = New ManagementObject(pfad)

   ' Attribute des Meta-Objekts
   Demo.PrintSubHeader("Metainformation:")
   Demo.Print("kompletter WMI-Pfad:" & mo.Path.Path)
   Demo.Print("Relativer Pfad:" & mo.Path.RelativePath)
   Demo.Print("Computer: " & mo.Path.Server)
   Demo.Print("Namespace:" & mo.Path.NamespacePath)
   Demo.Print("Standardpfad: " & ManagementPath.DefaultPath.Path)
   Demo.Print("Klassenname: " & mo.Path.ClassName)

   ' Attribute des Managed Objects
   Demo.PrintSubHeader("Zugriff auf einzelne Attribute")
   Demo.Print("Name: " & mo("Caption").ToString())
   Demo.Print("Dateisystem: " & mo("FileSystem").ToString())
   Demo.Print("Freie Bytes: " & Convert.ToUInt64(mo("FreeSpace")).ToString())
  End Sub



  ' WQL-Datenabfrage: Liste aller laufenden Dienste 
  Public Sub WMI_Dienste_Auflisten()
   ' Abfragebefehl (WQL)
   Const ABFRAGE As String = "select name,state from Win32_Service where state='running'"
   Const COMPUTER As String = "E45"

   Demo.PrintSubHeader("WQL-Datenabfrage: Liste aller laufenden Dienste")
   Dim scope As ManagementScope = New ManagementScope("\" & COMPUTER)
   ' Abfrage erzeugen 
   Dim sq As SelectQuery = New SelectQuery(ABFRAGE)
   Dim suche As ManagementObjectSearcher = New ManagementObjectSearcher(scope, sq)
   ' Abfrage ausfhren
   Dim menge As ManagementObjectCollection = suche.Get()
   ' Ergebnisse ausgeben
   For Each mo As ManagementObject In menge
	Demo.Print("Dienst: " & mo("Name").ToString() & " Zustand: " & mo("state").ToString())
   Next mo
  End Sub

 End Class
End Namespace