' .NET Framework 2.0 Demos
' (C) Dr. Holger Schwichtenberg
' http://www.dotnetframework.de
' =====================================

Imports Microsoft.VisualBasic
Imports System
Imports de.ITVisions.DemoViewer

Namespace NET2.SpracheCSharp
 #Region "Hilfsklassen"

 Public Class Mensch
  Public Name As String
 End Class

 Public Class Mann : Inherits Mensch
  Public Sub New(ByVal Name As String)
   Me.Name = Name
  End Sub
 End Class

 Public Class Frau : Inherits Mensch
  Public Sub New(ByVal Name As String)
   Me.Name = Name
  End Sub
 End Class
 #End Region
 #Region "Ohne Generics"
 Public Class DoppelFrauen
  Public Spieler1 As Frau
  Public Spieler2 As Frau
 End Class

 Public Class DoppelMnner
  Public Spieler1 As Mann
  Public Spieler2 As Mann
 End Class

 Public Class DoppelGemischt
  Public Spieler1 As Frau
  Public Spieler2 As Mann
 End Class

 Public Class DoppelAllgemein
  Public Spieler1 As Object
  Public Spieler2 As Object
 End Class
 #End Region
 #Region "Generic ohne Constraints"
 Public Class Doppel(Of SpielerTyp1, SpielerTyp2)
  Public Spieler1 As SpielerTyp1
  Public Spieler2 As SpielerTyp2

  Public Sub New(ByVal Spieler1 As SpielerTyp1, ByVal Spieler2 As SpielerTyp2)
   ' Speichern der Spieler
   Me.Spieler1 = Spieler1
   Me.Spieler2 = Spieler2

   ' Ausgabe
   If (Spieler1.GetType().ToString() <> Spieler2.GetType().ToString()) Then
	Demo.Print("Neues Gemischtes Doppelt!")
   Else
	Demo.Print("Neues Gleichgeschlechtliches Doppel!")
   End If

   ' Casting nur erforderlich, wenn kein Constraint!
   Demo.Print("Spieler 1 = " & (CType(IIf(TypeOf Spieler1 Is Mensch, Spieler1, Nothing), Mensch)).Name & "(" & Spieler1.GetType().ToString() & ")")
   Demo.Print("Spieler 2 = " & (CType(IIf(TypeOf Spieler2 Is Mensch, Spieler2, Nothing), Mensch)).Name & "(" & Spieler1.GetType().ToString() & ")")

  End Sub

 End Class
 #End Region
 #Region "Generic mit Constraint"
 Public Class Doppel_MitConstraint(Of SpielerTyp1 As {Mensch, New}, SpielerTyp2 As {Mensch, New})
  Public Spieler1 As SpielerTyp1
  Public Spieler2 As SpielerTyp2

  Public Sub New(ByVal Spieler1 As SpielerTyp1, ByVal Spieler2 As SpielerTyp2)

   ' Speichern der Spieler
   Me.Spieler1 = Spieler1
   Me.Spieler2 = Spieler2

   ' Ausgabe
   If (Spieler1.GetType().ToString() <> Spieler2.GetType().ToString()) Then
	Demo.Print("Neues Gemischtes Doppelt!")
   Else
	Demo.Print("Neues Gleichgeschlechtliches Doppel!")
   End If

   Demo.Print("Spieler 1 = " & Spieler1.Name & "(" & Spieler1.GetType().ToString() & ")")
   Demo.Print("Spieler 2 = " & Spieler2.Name & "(" & Spieler1.GetType().ToString() & ")")
  End Sub

 End Class
 #End Region
 #Region "client"
 <Demo> _
 Public Class GenerischeKlasse_demo
  Public Sub run()


   Dim f1 As Frau = New Frau("Angela Merkel")
   Dim f2 As Frau = New Frau("Rita Smuth")
   Dim m1 As Mann = New Mann("Gerhard Schrder")
   Dim m2 As Mann = New Mann("Edmund Stoiber")
   Dim m3 As Mann = New Mann("Joschka Fischer")


   Dim Politikerinnen As System.Collections.ArrayList = New System.Collections.ArrayList()

   Politikerinnen.Add(f1)
   Politikerinnen.Add(f2)
   Politikerinnen.Add(m2)

   Dim Politikerinnen2 As System.Collections.Generic.List(Of Frau) = New System.Collections.Generic.List(Of Frau)()

   Politikerinnen2.Add(f1)
   Politikerinnen2.Add(f2)
   'Politikerinnen2.Add(m2);






   Dim d1 As Doppel(Of Mann, Frau) = New Doppel(Of Mann, Frau)(m1, f1)
   Dim d4 As Doppel(Of Frau, Mann) = New Doppel(Of Frau, Mann)(f1, m2)
   Dim d2 As Doppel(Of Mann, Mann) = New Doppel(Of Mann, Mann)(m1, m2)
   Dim d3 As Doppel(Of Frau, Frau) = New Doppel(Of Frau, Frau)(f1, f2)

  ' Doppel<Frau, Frau> d5 = new Doppel<Frau, Frau>(f1, m2);


   Dim i As System.IO.DirectoryInfo = New System.IO.DirectoryInfo("C:\")
   Dim d As System.IO.FileInfo = New System.IO.FileInfo("c:\test.txt")

   Dim o As Doppel(Of System.IO.DirectoryInfo, System.IO.FileInfo) = New Doppel(Of System.IO.DirectoryInfo, System.IO.FileInfo)(i, d)


  'Doppel_MitConstraint<System.IO.FileInfo, System.IO.FileInfo> DateiDoppel = new Doppel_MitConstraint<System.IO.FileInfo, System.IO.FileInfo>(new System.IO.FileInfo(@"c:\temp.txt"), new System.IO.FileInfo("c:\text.txt"));


   Dim Maenner As System.Collections.ArrayList = New System.Collections.ArrayList()
   Maenner.Add(m1)
   Maenner.Add(m2)
   Maenner.Add(m3)
   Maenner.Add(f1)

   Dim Maenner2 As System.Collections.Generic.LinkedList(Of Mann) = New System.Collections.Generic.LinkedList(Of Mann)()
   Maenner2.AddFirst(m1)
   Maenner2.AddFirst(m2)
   Maenner2.AddFirst(m3)

   'System.Collections.Generic.List<Mann> mmm = new System.Collections.Generic.List<Mann>();
   'mmm.FindAll(System.Predicate<

   For Each m As Mann In Maenner2
	Demo.Print(m.Name)
   Next m
   'Maenner2.AddFirst(f1);











   Dim datei As System.IO.FileInfo = New System.IO.FileInfo("c:\temp.txt")
   'Doppel<System.IO.FileInfo, Mann> x = new Doppel<System.IO.FileInfo, Mann>(datei, m1);




   'Maenner2.AddFirst(f);


   ' Fehler:
   'Doppel<Mann, Mann> d2 = new Doppel<Mann, Mann>(m1, f);
   'Doppel<Mensch, Mensch> d2 = new Doppel<Mensch, Mensch>(m1, f2);

   '  Doppel<int, string> f2 = new Doppel<int, string>(2, "2");




   Dim dateien As System.Collections.Generic.SortedDictionary(Of String, System.IO.FileInfo) = New System.Collections.Generic.SortedDictionary(Of String, System.IO.FileInfo)()

   dateien.Add("Protokoll", New System.IO.FileInfo("c:\temp\Protokoll.txt"))
   dateien.Add("Eingabe", New System.IO.FileInfo("c:\temp\Eingabe.txt"))
   dateien.Add("Ausgabe", New System.IO.FileInfo("c:\temp\"))

   Dim MaennerClub As System.Collections.Generic.List(Of Mann) = New System.Collections.Generic.List(Of Mann)()

   '  MaennerClub.Add(new Mann());
   'Fehler
   'MaennerClub.Add(new Frau());

   Dim mliste2 As MaennerListe = New MaennerListe()

  End Sub

  Private Class MenschList : Inherits System.Collections.Generic.LinkedList(Of Mensch)

  End Class

  Private Class MaennerListe : Inherits System.Collections.Generic.LinkedList(Of Mann)

  End Class


 End Class
 #End Region
End Namespace
