using System;
using System.Collections.Generic;
using System.Text;
using System.ServiceModel;
using de.WWWings.PassagierSystem;

namespace de.WWWings.Dienste
{

 [ServiceContract(Namespace = "WWWings")]
 [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
 public class BuchungsService
 {

  public BuchungsService()
  {
   Console.WriteLine("Neue Instanz der Fassade Buchungsservice");
  }

  [OperationContract]
  public long BuchungErstellenMitIDs(long PassagierNr, long FlugNr)
  {
   System.Console.WriteLine("Buchung Passagier: " + PassagierNr + " fr Flug " + FlugNr);
   de.WWWings.PassagierSystem.Passagier p = new de.WWWings.PassagierSystem.Passagier(PassagierNr);
   return p.Buchen(FlugNr);
  }

  [OperationContract]
  public long MehrfachBuchungErstellenMitIDs(long PassagierNr, long[] FlugNummern)
  {
   System.Console.WriteLine("Buchung Passagier: " + PassagierNr + " fr " + FlugNummern.Length + " Teilstrecken");
   return de.WWWings.Buchung_BLManager.Buchen(FlugNummern, PassagierNr);
  }


  [OperationContract]
  public Buchung BuchungErstellenMitObjekten(Flug f, Passagier p)
  {
   System.Console.WriteLine("Buchung Passagier: " + p.PID + " fr Flug " + f.FlugNr);
   return de.WWWings.Buchung_BLManager.Buchen(f, p);
  }

  [OperationContract]
  public BuchungsMenge HoleBuchungenFuerPassagier(long PassagierID)
  {
   return de.WWWings.Buchung_BLManager.HoleBuchungenFuerPassagier(PassagierID);
  }

  [OperationContract]
  public BuchungsMenge HoleBuchungen(long Buchungscode)
  {
   return de.WWWings.Buchung_BLManager.HoleBuchungen(Buchungscode);
  }


  [OperationContract]
  public void AlleBuchungenLoeschenFuerPassagier(long PassagierID)
  {
   de.WWWings.Buchung_BLManager.AlleBuchungenLoeschenFuerPassagier(PassagierID);
  }

  [OperationContract]
  public void BuchungenLoeschen(long Buchungscode)
  {
   de.WWWings.Buchung_BLManager.BuchungenLoeschen(Buchungscode);
  }



 }
}
