using System;
using System.ServiceModel;
using System.Threading;
using System.Security.Permissions;

namespace de.WWWings.Dienste
{


 /// <summary>
 /// Daten als Antwort auf einen Ping eines Clients, verwendet  [System.Runtime.Serialization.DataContract]
 /// </summary>
 [System.Runtime.Serialization.DataContract]
 [XmlSerializerFormat]
 public class PingInfo
 {

  public PingInfo()
  {
   DBInfo.AnzFluege = de.WWWings.FlugBLManager.AnzFluege();
   DBInfo.AnzBuchungen = de.WWWings.Buchung_BLManager.AnzahlBuchungen();
   DBInfo.AnzPassagiere = de.WWWings.Passagier_BLManager.AnzahlPassagiere();
  }

  [System.Runtime.Serialization.DataMember]
  public DBInfo DBInfo = new DBInfo();

  [System.Runtime.Serialization.DataMember]
  public string ComputerName;

  [System.Runtime.Serialization.DataMember]
  public DateTime ServerTime
  {
   get { return DateTime.Now; }
   set { }
  }

  [System.Runtime.Serialization.DataMember]
  public string ServerIdentity
  {
   get
   {
    return GetIdentity();
   }
   set { }
  }

  public static string GetIdentity()
  {
   string WindowsID = "n/a";
   string WCFID = "n/a";
   if (ServiceSecurityContext.Current != null && ServiceSecurityContext.Current.IsAnonymous) WCFID = "anonym";
   try
   {
    WindowsID = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
    WCFID = ServiceSecurityContext.Current.WindowsIdentity.Name; // +" " + ServiceSecurityContext.Current.PrimaryIdentity.Name;
   }
   catch (Exception)
   {

   }
   string ausgabe = "Server-Identitt: " + WindowsID + " Client-Identitt: " + WCFID;


   return ausgabe;
  }

  [System.Runtime.Serialization.DataMember]
  public string Session
  {
   get { return OperationContext.Current.SessionId; }
   set { }
  }

  [System.Runtime.Serialization.DataMember]
  public System.Version Version
  {
   get { return System.Reflection.Assembly.GetExecutingAssembly().GetName().Version; }
   set { }
  }
 }

 /// <summary>
 /// Unterklasse fr Statistik aus der Datenbank, verwendet  [System.Serializable]
 /// </summary>
 [System.Serializable]
 public class DBInfo
 {
  public long AnzFluege;
  public long AnzPassagiere;
  public long AnzBuchungen;
 }


 /// <summary>
 /// Rckrufschnittstelle fr WCF-Duplex
 /// </summary>
 public interface IPingDuplexCallback
 {
  [OperationContract(IsOneWay = true)]
  void ClientPing(string Server);
 }


 // service contract.
 //[ServiceContract(Namespace = "http://de.ITVisions.Samples.WCF", SessionMode = SessionMode.Required)]


 [ServiceContract(Namespace = "http://de.ITVisions.Samples.WCF", SessionMode = SessionMode.Required,
                 CallbackContract = typeof(IPingDuplexCallback))]
 public interface ITestService
 {
  [OperationContract]
  double Add(double n1, double n2);
  [OperationContract]
  double Subtract(double n1, double n2);
  [OperationContract]
  double Multiply(double n1, double n2);
  [OperationContract]
  double Divide(double n1, double n2);
  [OperationContract]
  string GetInstanceContextMode();
  [OperationContract]
  int GetInstanceId();
  [OperationContract(IsInitiating = false)]
  int GetOperationCount();
  [OperationContract]
  string GetServerIdentity();
  [OperationContract]
  string GetServerIdentity_Impersonated();
  [OperationContract]
  string GetServerName();
  [OperationContract]
  PingInfo Ping();
  [OperationContract(IsOneWay = true)]
  void SendeLebenszeichen(string Client);
  [OperationContract(IsOneWay = true)]
  void AsyncPing(string Client);
  [OperationContract(IsTerminating = true)]
  void SitzungBeenden();
 }

 // Dienst
 //[ServiceBehavior(InstanceContextMode = InstanceContextMode.PerSession)]
 public class TestService : ITestService
 {
  static Object syncObject = new object();
  static int AnzahlInstanzen;

  int InstanzID;
  int AnzahlAufrufe;

  public TestService()
  {
   //Console.WriteLine("Serverinstanz von TestService erzeugt!");
   lock (syncObject)
   {
    AnzahlInstanzen++;
    InstanzID = AnzahlInstanzen;
   }
  }

  public double Add(double n1, double n2)
  {
   AnzahlAufrufe++;
   return n1 + n2;
  }

  public double Subtract(double n1, double n2)
  {
   Interlocked.Increment(ref AnzahlAufrufe);
   return n1 - n2;
  }

  public double Multiply(double n1, double n2)
  {
   Interlocked.Increment(ref AnzahlAufrufe);
   return n1 * n2;
  }

  public double Divide(double n1, double n2)
  {
   Interlocked.Increment(ref AnzahlAufrufe);
   return n1 / n2;
  }


  public string GetInstanceContextMode()
  {
   // Return the InstanceContextMode of the service
   ServiceHost host = (ServiceHost)OperationContext.Current.Host;
   ServiceBehaviorAttribute behavior = host.Description.Behaviors.Find<ServiceBehaviorAttribute>();
   return behavior.InstanceContextMode.ToString();
  }

  // Impersonifizierung
  [PrincipalPermission(SecurityAction.Demand, Role = "Users")]
  [OperationBehavior(Impersonation = ImpersonationOption.Required)]
  public string GetServerIdentity_Impersonated()
  {   // Return the InstanceContextMode of the service
   string ausgabe = PingInfo.GetIdentity();
   Console.WriteLine("\nIdentittsbestimmung in einer impersonfizierten Operation:");
   Console.WriteLine(ausgabe);
   return ausgabe;
  }

  // Keine Impersonifizierung
  public string GetServerIdentity()
  {   // Return the InstanceContextMode of the service
   string ausgabe = PingInfo.GetIdentity();
   Console.WriteLine("\nIdentittsbestimmung in einer NICHT impersonfizierten Operation:");
   Console.WriteLine(ausgabe);
   return ausgabe;
  }


  public string GetServerName()
  {   // Return the InstanceContextMode of the service
   return System.Environment.MachineName;
  }

  public int GetInstanceId()
  {   // Return the id for this instance
   return InstanzID;
  }

  private int Counter = 0;


  public void SendeLebenszeichen(string Client)
  {
   Counter++;

   Console.WriteLine("Die ist das {0}. Lebenzeichen von Client {1} und das {2}. Lebenszeichen insgesamt: ", Counter, Client, Counter);
  }

  public void SendeLebenszeichen1(string Client)
  {
   Console.WriteLine("Die ist ein Lebenzeichen von Client: " + Client);
  }


  public void AsyncPing(string Client)
  {
   Console.WriteLine("Async-Ping von Client: " + Client);
   // Hole Zeiger auf Implementierung des Server-Proxies fr die Rckrufschnittstelleimplementierung des Clients 
   IPingDuplexCallback client = null;
   client = OperationContext.Current.GetCallbackChannel<IPingDuplexCallback>();
   // Rufe Client 10x auf
   for (int a = 0; a < 10; a++)
   {
    client.ClientPing("Rckruf #" + a + " von " + System.Environment.MachineName);
    System.Threading.Thread.Sleep(1000);
   }
  }


  public PingInfo Ping()
  {
   Console.Write(".");
   lock (this)
   {
    //Console.WriteLine(DateTime.Now.ToLongTimeString() + ": Ping Start...");
    string client = "unbekannt";
    if ((OperationContext.Current != null) && (OperationContext.Current.IncomingMessageHeaders.From != null))
    {
     client = OperationContext.Current.IncomingMessageHeaders.From.ToString() + OperationContext.Current.IncomingMessageHeaders.From.Identity.ToString();
    }

    //Console.WriteLine(DateTime.Now.ToLongTimeString() + ": Ping from " + client);
    PingInfo p = new PingInfo();
    //Console.WriteLine(DateTime.Now.ToLongTimeString() + ": Ping Ende!");
    return p;
   }
  }
  public void SitzungBeenden()
  {
   Console.WriteLine("Sitzung wird beendet!");
  }



  public int GetOperationCount()
  {   // Return the number of ICalculator operations performed 
   // on this instance
   lock (syncObject)
   {
    return AnzahlAufrufe;
   }
  }


 }
}

