using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;

namespace de.WWWings.Workflow
{



 public sealed partial class Buchungsworkflow : SequentialWorkflowActivity
 {

  #region Parameter
  // #############################################################################
  private string _Aufrufer;

  public string Aufrufer
  {
   get { return _Aufrufer; }
   set
   {
    _Aufrufer = value;
    Console.WriteLine("Aufgerufen von: " + _Aufrufer.ToString());
   }
  }

  private long _Buchungcode;

  public long Buchungscode
  {
   get { return _Buchungcode; }
  }
  #endregion

  #region Daten
  // #############################################################################

  private long AktuellePassagierNr;
  private long AktuelleFlugNr;

  public static DependencyProperty PersonenDatenProperty = DependencyProperty.Register("PersonenDaten", typeof(de.WWWings.Workflow.PersonenDaten), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Parameters")]
  public PersonenDaten PersonenDaten
  {
   get
   {
    return ((de.WWWings.Workflow.PersonenDaten)(base.GetValue(de.WWWings.Workflow.Buchungsworkflow.PersonenDatenProperty)));
   }
   set
   {
    base.SetValue(de.WWWings.Workflow.Buchungsworkflow.PersonenDatenProperty, value);
   }
  }


  public static DependencyProperty FlugDatenProperty = DependencyProperty.Register("FlugDaten", typeof(de.WWWings.Workflow.FlugDaten), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Parameters")]
  public FlugDaten FlugDaten
  {
   get
   {
    return ((de.WWWings.Workflow.FlugDaten)(base.GetValue(de.WWWings.Workflow.Buchungsworkflow.FlugDatenProperty)));
   }
   set
   {
    base.SetValue(de.WWWings.Workflow.Buchungsworkflow.FlugDatenProperty, value);
   }
  }


  public static DependencyProperty codeActivity1_ExecuteCode1Event = DependencyProperty.Register("codeActivity1_ExecuteCode1", typeof(System.EventHandler), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Handlers")]
  public event EventHandler codeActivity1_ExecuteCode1
  {
   add
   {
    base.AddHandler(codeActivity1_ExecuteCode1Event, value);
   }
   remove
   {
    base.RemoveHandler(codeActivity1_ExecuteCode1Event, value);
   }
  }


  public static Exception AusgebuchtFehler = new System.Exception("Flug ist ausgebucht!");
  public static DependencyProperty FlugAusgebucht_FehlerdatenProperty = DependencyProperty.Register("FlugAusgebucht_Fehlerdaten", typeof(System.Exception), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Handlers")]
  public Exception FlugAusgebucht_Fehlerdaten
  {
   get
   {
    return ((System.Exception)(base.GetValue(de.WWWings.Workflow.Buchungsworkflow.FlugAusgebucht_FehlerdatenProperty)));
   }
   set
   {
    base.SetValue(de.WWWings.Workflow.Buchungsworkflow.FlugAusgebucht_FehlerdatenProperty, value);
   }
  }


  public static DependencyProperty PersonProperty = DependencyProperty.Register("Person", typeof(de.WWWings.Workflow.PersonenDaten), typeof(de.WWWings.Workflow.Buchungsworkflow));

  [DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility.Visible)]
  [BrowsableAttribute(true)]
  [CategoryAttribute("Parameters")]
  public PersonenDaten Person
  {
   get
   {
    return ((de.WWWings.Workflow.PersonenDaten)(base.GetValue(de.WWWings.Workflow.Buchungsworkflow.PersonProperty)));
   }
   set
   {
    base.SetValue(de.WWWings.Workflow.Buchungsworkflow.PersonProperty, value);
   }
  }


  #endregion

  public Buchungsworkflow()
  {
   InitializeComponent();
  }

  private void A_Start_ExecuteCode(object sender, EventArgs e)
  {
   Console.WriteLine("Aufgerufen von: " + _Aufrufer.ToString());
   Trace("Buchungsstart...");
  }

  private void A_PassagierAnlegen_ExecuteCode(object sender, EventArgs e)
  {
   AktuellePassagierNr = de.WWWings.Passagier_BLManager.HolePassagierNummer(this.PersonenDaten.Name);

   if (AktuellePassagierNr != 0)
   {
    Trace(String.Format("Passagier {0} mit schon vorhanden unter ID: {1}", this.PersonenDaten.Name, AktuellePassagierNr));
   }
   else
   {
    Trace(String.Format("Passagier {0} mit E-Mail {1} wird angelegt...", this.PersonenDaten.Name, this.PersonenDaten.EMail));
    de.WWWings.Passagier_BLManager.NeuerPassagier(this.PersonenDaten.Name, this.PersonenDaten.EMail);
   }
  }

  private void PlaetzVerfuegbarkeitPruefen_ExecuteCode(object sender, EventArgs e)
  {
   Trace(String.Format("Prfe Platzverfgbarkeit in Workflow {0}...", this.AktuelleFlugNr));
  }

  private void PruefeVerfuegbarkeit(object sender, ConditionalEventArgs e)
  {
   de.WWWings.Flug f = de.WWWings.FlugBLManager.HoleFlug(this.AktuelleFlugNr);
   Trace("Freie Pltze: " + f.FreiePlaetze);
   // Linker Ast = True = Nicht ausreichend Plaetze
   e.Result = (f.FreiePlaetze < this.FlugDaten.Plaetze);
  }

  private void PlaetzeBuchen_ExecuteCode(object sender, EventArgs e)
  {
   Trace(String.Format("Buche Pltze auf Flug {0}...", this.AktuelleFlugNr));

   de.WWWings.PassagierSystem.Passagier p;
   p = new de.WWWings.PassagierSystem.Passagier(AktuellePassagierNr);

   long b = p.Buchen(this.AktuelleFlugNr);
   this._Buchungcode = b;

   Trace("Buchung erfolgt. Buchungscode: " + b);

  }



  private void Abbuchen_ExecuteCode(object sender, EventArgs e)
  {
   Trace("Betrag wird abgebucht...");
  }


  private void codeActivity1_ExecuteCode(object sender, EventArgs e)
  {
   DateTime Start = System.DateTime.Now;

   while (System.DateTime.Now < Start.AddSeconds(15))
   {

   }
  }

  private void KeinPlatz_ExecuteCode(object sender, EventArgs e)
  {
   TraceError("Kein Platz auf diesem Flug!");
  }

  private void Fehlerbehandlung_ExecuteCode(object sender, EventArgs e)
  {
   TraceError("Nicht weiter behandelter Fehler!");
  }


  private void codeActivity1_ExecuteCode_1(object sender, EventArgs e)
  {

  }

  private void Fehlerbehandlung_FalscheFlugnummer_Execute(object sender, EventArgs e)
  {

  }

  #region Hilfsroutinen
  private void Trace(string s)
  {
   Console.ForegroundColor = ConsoleColor.Green;
   Console.Write("Workflow {0} in Thread {1}: ", this.WorkflowInstanceId, System.Threading.Thread.CurrentThread.ManagedThreadId);
   Console.ForegroundColor = ConsoleColor.White;
   Console.WriteLine(s);
   this.TrackData(s);
  }

  private void TraceError(string s)
  {
   Console.ForegroundColor = ConsoleColor.Red;
   Console.Write("Workflow {0} in Thread {1}: ", this.WorkflowInstanceId, System.Threading.Thread.CurrentThread.ManagedThreadId);
   Console.ForegroundColor = ConsoleColor.White;
   Console.WriteLine(s);
   this.TrackData(s);
  }

  #endregion

  public byte FlugZaehler = 0;

  private void BedingungFuerSchleifeUeberFlugNummern(object sender, ConditionalEventArgs e)
  {

   if (this.FlugDaten.FlugNummern.Length > this.FlugZaehler)
   {
    e.Result = true;
    this.AktuelleFlugNr = this.FlugDaten.FlugNummern[this.FlugZaehler];
    Trace("Aktueller Flug: " + this.AktuelleFlugNr);
    this.FlugZaehler++;
   }
   else
   {
    e.Result = false;
   }



  }

  private void ENDE_ExecuteCode(object sender, EventArgs e)
  {
   Trace("Buchung beendet!");
  }

  private void codeActivity1_ExecuteCode_2(object sender, EventArgs e)
  {
   TraceError("Fehler!");
  }

 }

}
