//INSTANT C# NOTE: Formerly VB.NET project-level imports:
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

using System.Web.UI;
using System.Web.UI.Design;
using System.Web.UI.WebControls;
using System.ComponentModel;

namespace WWWings.WebSteuerelemente
{

 /// <summary>
 /// Composite Control ohne Design-Time
 /// </summary>
 [System.Drawing.ToolboxBitmap("BeschrifteteTextBox_CC1.bmp")]

 public class BeschrifteteTextBox_CC1 : WebControl
 {

  // === Die Beschriftung 

  [Description("Die Beschriftung der Textbox"), Category("Darstellung")]
  public string Beschriftung
  {
   get
   {
    string C_BeschriftungsText = "";

    if (ViewState["Beschriftung"] != null) C_BeschriftungsText = System.Convert.ToString(ViewState["Beschriftung"]);
    if (C_BeschriftungsText == null)
     return string.Empty;
    return C_BeschriftungsText;
   }
   set
   {
    ViewState["Beschriftung"] = value;
   }
  }

  // === Das Aussehen der Beschriftung
  [Description("Die Cascading StyleSheet Klasse fr die Beschriftung"), Category("Darstellung")]
  public string BeschriftungsStyle
  {
   get
   {
    string C_BeschriftungsStyle = System.Convert.ToString(ViewState["BeschriftungsStyle"]);
    if (C_BeschriftungsStyle == null)
     return string.Empty;
    return C_BeschriftungsStyle;
   }
   set
   {
    ViewState["BeschriftungsStyle"] = value;
   }
  }

  // === Ausrichtungsarten
  public enum Ausrichtung : byte
  {
   Links,
   Oben,
   Rechts,
   Unten
  }

  // === Ausrichtung des Labels
  [Description("Die Ausrichtung der Beschriftung im Verhltnis zur TextBox"), Category("Darstellung"), DefaultValue("Links")]
  public Ausrichtung BeschriftungsAusrichtung
  {
   get
   {
    Ausrichtung C_BeschriftungsAusrichtung = Ausrichtung.Links;
    if (ViewState["BeschriftungsAusrichtung"] != null) C_BeschriftungsAusrichtung = (Ausrichtung)(ViewState["BeschriftungsAusrichtung"]);
    return C_BeschriftungsAusrichtung;
   }
   set
   {
    ViewState["BeschriftungsAusrichtung"] = value;
   }
  }

  // === Die TextBox
  [Description("Der Text der TextBox"), Category("Darstellung")]
  public string TextBoxText
  {
   get
   {
    string C_TextBoxText = System.Convert.ToString(ViewState["TextBoxText"]);
    if (C_TextBoxText == null)
     return string.Empty;
    return C_TextBoxText;
   }
   set
   {
    ViewState["TextBoxText"] = value;
   }
  }

  // === Der Style der TextBox
  [Description("Der Style der TextBox"), Category("Darstellung")]
  public string TextBoxStyle
  {
   get
   {
    string C_TextBoxStyle = System.Convert.ToString(ViewState["TextBoxStyle"]);
    if (C_TextBoxStyle == null)
     return string.Empty;
    return C_TextBoxStyle;
   }
   set
   {
    ViewState["TextBoxStyle"] = value;
   }
  }

  // === berschreiben der CreateChildMethode
  protected override void CreateChildControls()
  {
   base.CreateChildControls();

   // --- Erstellen der Beschriftung
   Label C_Beschriftung = new Label();
   C_Beschriftung.Text = Beschriftung;
   if (BeschriftungsStyle != "")
    C_Beschriftung.CssClass = BeschriftungsStyle;

   // --- Erstellen der TextBox
   TextBox C_TextBox = new TextBox();
   C_TextBox.Text = TextBoxText;
   if (TextBoxStyle != "")
    C_TextBox.CssClass = TextBoxStyle;

   if (BeschriftungsAusrichtung == Ausrichtung.Links)
   {
    // --- Beschriftung wird links ausgegeben

    // --- 1. Steuerelement : Beschriftung
    Controls.Add(C_Beschriftung);
    // --- 2. Steuerelement : Leerzeichen
    Controls.Add(new LiteralControl(" "));
    // --- 3. Steuerelement : Textbox
    Controls.Add(C_TextBox);

   }
   else if (BeschriftungsAusrichtung == Ausrichtung.Oben)
   {
    // --- Beschriftung wird oben ausgegeben

    // --- 1. Steuerelement : Beschriftung
    Controls.Add(C_Beschriftung);
    // --- 2. Steuerelement : Zeilenumbruch
    Controls.Add(new LiteralControl("<br>"));
    // --- 3. Steuerelement : Textbox
    Controls.Add(C_TextBox);

   }
   else if (BeschriftungsAusrichtung == Ausrichtung.Unten)
   {
    // --- Beschriftung wird unten ausgegeben

    // --- 1. Steuerelement : Textbox
    Controls.Add(C_TextBox);
    // --- 2. Steuerelement : Zeilenumbruch
    Controls.Add(new LiteralControl("<br>"));
    // --- 3. Steuerelement : Beschriftung
    Controls.Add(C_Beschriftung);

   }
   else if (BeschriftungsAusrichtung == Ausrichtung.Rechts)
   {
    // --- Beschriftung wird rechts ausgegeben

    // --- 1. Steuerelement : Textbox
    Controls.Add(C_TextBox);
    // --- 2. Steuerelement : Leerzeichen
    Controls.Add(new LiteralControl(" "));
    // --- 3. Steuerelement : Beschriftung
    Controls.Add(C_Beschriftung);

   }

  }

  protected override void Render(HtmlTextWriter Ausgabe)
  {

   RenderChildren(Ausgabe);

  }

 }

} //end of root namespace