// ///////////////////////////////////////////////////////////
// /Steuerelemente/DatumZeitAnzeige.vb
// ///////////////////////////////////////////////////////////

//INSTANT C# NOTE: Formerly VB.NET project-level imports:
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

using System.Web.UI;
using System.Web.UI.Design;
using System.Web.UI.WebControls;
using System.ComponentModel;

namespace WWWings.WebSteuerelemente
{

 /// <summary>
 /// DatumZeit-Steuerelemente
 /// </summary>
 [System.Web.UI.PartialCaching(10, "*", "", ""), Designer(typeof(DatumZeitAnzeigeDesign))]
 public class DatumZeitAnzeige : WebControl
 {

  // ==== Formate fr die Uhrzeitdarstellung
  public enum UhrzeitFormatType : byte
  {
   Keine,
   Kurzformat,
   Langformat
  }

  // ==== Formate fr die Datumsdarstellung
  public enum DatumFormatType : byte
  {
   Keine,
   Kurzformat,
   Langformat
  }

  // === Attribute

  // === Soll die Systemzeit verwendet werden?
  private bool _SystemDatumZeit = true;
  [Description("Gibt an ob automatisch die aktuelle Systemzeit verwendet werden soll, oder der manuell gesetzte Wert."), Category("Darstellung"), Bindable(false), DefaultValue(true)]
  public bool SystemDatumZeit
  {
   get
   {
    return _SystemDatumZeit;
   }
   set
   {
    if (value == true)

     _SystemDatumZeit = value;
   }
  }

  // === bergebener Datums- und Zeitwert, falls die Systemzeit nicht bernommen wird.
  private System.DateTime _DatumZeit;
  [Bindable(true), Category("Daten"), Description("Datums- und Zeitwert")]
  public System.DateTime DatumZeit
  {
   get
   {
    return _DatumZeit;
   }
   set
   {
    SystemDatumZeit = false;
    _DatumZeit = value;
   }
  }

  // === Darstellung beider Werte nebeneinander?
  private bool _Nebeneinander;
  [Description("Gibt die Ausrichtung von Datum und Uhrzeit zueinander an."), Category("Darstellung"), DefaultValue(true)]
  public bool Nebeneinander
  {
   get
   {
    return _Nebeneinander;
   }
   set
   {
    _Nebeneinander = value;
   }
  }

  // === Darstellungsformat fr die Uhrzeit
  private UhrzeitFormatType _UhrzeitStyle = UhrzeitFormatType.Kurzformat;
  [Description("Format der Uhrzeit"), Category("Darstellung"), DefaultValue(UhrzeitFormatType.Kurzformat)]
  public UhrzeitFormatType UhrzeitFormat
  {
   get
   {
    return _UhrzeitStyle;
   }
   set
   {
    _UhrzeitStyle = value;
   }
  }

  // === Darstellungsformat fr das Datum
  private DatumFormatType _DatumFormat = DatumFormatType.Kurzformat;
  [Description("Anzeigeformat des Datums"), Category("Darstellung"), DefaultValue(DatumFormatType.Kurzformat)]
  public DatumFormatType DatumsAnzeige
  {
   get
   {
    return _DatumFormat;
   }
   set
   {
    _DatumFormat = value;
   }
  }

  // === Methoden

  // === Erzeugen der Darstellung
  protected override void Render(HtmlTextWriter Ausgabe)
  {

   System.DateTime _TempDatumZeit = DateTime.MinValue;

   if (SystemDatumZeit)
    _TempDatumZeit = System.DateTime.Now;
   else
    _TempDatumZeit = DatumZeit;

   Ausgabe.WriteBeginTag("span");
   Ausgabe.Write(HtmlTextWriter.TagRightChar);

   if (DatumsAnzeige == DatumFormatType.Kurzformat)
    Ausgabe.Write(_TempDatumZeit.ToShortDateString());
   else if (DatumsAnzeige == DatumFormatType.Langformat)
    Ausgabe.Write(_TempDatumZeit.ToLongDateString());

   if (DatumsAnzeige != DatumFormatType.Keine & UhrzeitFormat != UhrzeitFormatType.Keine)
   {
    if (Nebeneinander)
     Ausgabe.Write("&nbsp;");
    else
     Ausgabe.Write("<br>");
   }

   if (UhrzeitFormat == UhrzeitFormatType.Kurzformat)
    Ausgabe.Write(_TempDatumZeit.ToShortTimeString());
   else if (UhrzeitFormat == UhrzeitFormatType.Langformat)
    Ausgabe.Write(_TempDatumZeit.ToLongTimeString());

   Ausgabe.WriteEndTag("span");
  }

 }

}