// ///////////////////////////////////////////////////////////
// /Steuerelemente/DatumZeitAnzeigeDesign.vb
// ///////////////////////////////////////////////////////////

//INSTANT C# NOTE: Formerly VB.NET project-level imports:
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;

using System.Web.UI;
using System.Web.UI.Design;
using System.Web.UI.WebControls;
using System.ComponentModel;

namespace WWWings.WebSteuerelemente
{
	public class DatumZeitAnzeigeDesign : ControlDesigner
	{

		// === Angepasste Darstellung eine Steuerelementes zur Entwurfszeit
		public override string GetDesignTimeHtml()
		{

			DatumZeitAnzeige AktuellesSteuerelement = (DatumZeitAnzeige)Component;

			if (AktuellesSteuerelement.DatumsAnzeige == DatumZeitAnzeige.DatumFormatType.Keine & AktuellesSteuerelement.UhrzeitFormat == DatumZeitAnzeige.UhrzeitFormatType.Keine)
			{

				// Es wird weder Uhrzeit noch Datum angezeigt.
				return GetEmptyDesignTimeHtml();

			}
			else
			{
				// --- Sicherstellung das die ChildControls bereits erstellt 
				// --- sind bevor der Render Vorgang beginnt.
				ControlCollection Steuerelemente = AktuellesSteuerelement.Controls;
				return base.GetDesignTimeHtml();
			}

		}

		// === Ausgabe fr den Fall das ein Steuerelement keinen Inhalt darstellt
		protected override string GetEmptyDesignTimeHtml()
		{
			string AusgabeText = null;
			AusgabeText = "Es wird weder Uhrzeit noch Datum angezeigt!";
			return CreatePlaceHolderDesignTimeHtml(AusgabeText);
		}

		// === Ausgabe fr den Fall das innerhalb des Darstellungsvorgang 
		// === ein Fehler aufgetreten ist
		protected override string GetErrorDesignTimeHtml(Exception e)
		{
			string AusgabeText = null;
			AusgabeText = "Es ist ein Fehler Aufgetreten! " + e.Message;
			return CreatePlaceHolderDesignTimeHtml(AusgabeText);
		}

	}

} //end of root namespace