' ///////////////////////////////////////////////////////////
' /Steuerelemente/ErweitereTextBox.vb
' ///////////////////////////////////////////////////////////

Imports System.ComponentModel
Imports System.Web.UI
Imports System.Web.UI.Design
Imports System.Web.UI.WebControls



' ### Definition der ErweiterteTextbox - Klasse 
<Designer(GetType(ErweiterteTextBoxDesign))> _
Public Class ErweiterteTextBox
    Inherits WebControl
    Implements INamingContainer

    ' === Die beinhaltete Steuerelemente
    Dim C_Text As New TextBox()
    Dim C_Beschriftung As New Label()

    ' === Mgliche Ausrichtungen fr das Label
    Enum Ausrichtung As Byte
        links
        rechts
        oben
        unten
    End Enum

    ' === Mgliche Ausrichtungen fr den Warnhinweis
    Enum WarnungAusrichtung As Byte
        rechts
        unten
    End Enum

#Region "Attribute"

    ' === Attribute 
    <DefaultValue("Beschriftung"), _
    Category("Darstellung")> _
    Public Property Beschriftung() As String
        Get
            Return C_Beschriftung.Text
        End Get
        Set(ByVal Value As String)
            C_Beschriftung.Text = Value
            ChildControlsCreated = False
        End Set
    End Property

    <DefaultValue(Ausrichtung.links), _
    Category("Darstellung")> _
    Public Property BeschriftungAusrichtung() As Ausrichtung
        Get
            Dim _BeschriftungAusrichtung As Ausrichtung = CType(ViewState("BeschriftungAusrichtung"), Ausrichtung)
            Return _BeschriftungAusrichtung
        End Get
        Set(ByVal Value As Ausrichtung)
            ViewState("BeschriftungAusrichtung") = Value
            ChildControlsCreated = False
        End Set
    End Property

    <Category("Daten"), _
    Description("Der eigentliche Text")> _
    Public Property [Text]() As String
        Get
            Return C_Text.Text
        End Get
        Set(ByVal Value As String)
            C_Text.Text = Value
            ChildControlsCreated = False
        End Set
    End Property

    <Category("Darstellung"), _
    Description("Gibt an ob die Eingabe erforderlich ist"), _
    DefaultValue(True)> _
    Public Property EingabeErforderlich() As Boolean
        Get
            If IsNothing(ViewState("EingabeErforderlich")) Then
                Return True
            Else
                Dim _EingabeErforderlich As Boolean = CType(ViewState("EingabeErforderlich"), Boolean)
                Return _EingabeErforderlich
            End If
        End Get
        Set(ByVal Value As Boolean)
            ViewState("EingabeErforderlich") = Value
            ChildControlsCreated = False
        End Set
    End Property

    <Category("Darstellung"), _
    Description("Text der als Warnung ausgegeben wird falls eingabe nicht erfolgte.")> _
    Public Property EingabeFehltWarnung() As String
        Get
            Dim _EingabeFehltWarnung As String = CStr(ViewState("EingabeFehltWarnung"))
            Return _EingabeFehltWarnung
        End Get
        Set(ByVal Value As String)
            ViewState("EingabeFehltWarnung") = Value
            ChildControlsCreated = False
        End Set
    End Property

    <Category("Darstellung"), _
    Description("An welcher Position soll die Warnung ausgegeben werden.")> _
    Public Property WarnungPosition() As WarnungAusrichtung
        Get
            Dim _WarnungPosition As WarnungAusrichtung = CType(ViewState("WarnungPosition"), WarnungAusrichtung)
            Return _WarnungPosition
        End Get
        Set(ByVal Value As WarnungAusrichtung)
            ViewState("WarnungPosition") = Value
            ChildControlsCreated = False
        End Set
    End Property

    Public Overrides ReadOnly Property Controls() As ControlCollection
        Get
            EnsureChildControls()
            Return MyBase.Controls
        End Get
    End Property

#End Region

#Region "Methoden"

    ' === Methoden
    Protected Overrides Sub CreateChildControls()

        C_Beschriftung.Text = Beschriftung

        C_Text.ID = "text1"
        C_Text.Text = [Text]

        If BeschriftungAusrichtung = Ausrichtung.links Then
            ' --- Beschriftung ist links
            Controls.Add(C_Beschriftung)
            Controls.Add(New LiteralControl("&nbsp;"))
            Controls.Add(C_Text)

        ElseIf BeschriftungAusrichtung = Ausrichtung.oben Then
            ' --- Beschriftung ist oben
            Controls.Add(C_Beschriftung)
            Controls.Add(New LiteralControl("<br>"))
            Controls.Add(C_Text)

        ElseIf BeschriftungAusrichtung = Ausrichtung.rechts Then
            ' --- Beschriftung ist rechts
            Controls.Add(C_Text)
            Controls.Add(New LiteralControl("&nbsp;"))
            Controls.Add(C_Beschriftung)

        ElseIf BeschriftungAusrichtung = Ausrichtung.unten Then
            ' --- Beschriftung ist unten
            Controls.Add(C_Text)
            Controls.Add(New LiteralControl("<br>"))
            Controls.Add(C_Beschriftung)

        End If

        If EingabeErforderlich Then

            If WarnungPosition = WarnungAusrichtung.rechts Then
                Controls.Add(New LiteralControl("&nbsp;"))
            Else
                Controls.Add(New LiteralControl("<br>"))
            End If

            Dim C_Validator As New RequiredFieldValidator()
            C_Validator.ControlToValidate = "text1"
            C_Validator.Display = ValidatorDisplay.Dynamic
            C_Validator.Text = EingabeFehltWarnung
            Controls.Add(C_Validator)
        End If

    End Sub

#End Region

End Class

' ### Die Design-Time Ansicht der ErweiterteTextbox - Klasse 
Public Class ErweiterteTextBoxDesign
    Inherits System.Web.UI.Design.ControlDesigner

    Public Overrides Function GetDesignTimeHtml() As String

        Dim AktuellesSteuerelement As Control = CType(Component, Control)
        ' --- Sicherstellung das die ChildControls bereits erstellt 
        ' --- sind bevor der Render Vorgang beginnt.
        Dim Steuerelemente As ControlCollection = AktuellesSteuerelement.Controls
        Return MyBase.GetDesignTimeHtml()

    End Function

End Class
