' ////////////////////////////////////////////
' Steuerelemente/PostBackZaehler.vb
' ////////////////////////////////////////////

' ### Dieses Steuerelement pflegt die Anzahl der erfolgten Postbacks selbststndig.
' ### Und gibt sie aus.
' ### Bei Eintreten des 5. und des 10. PostBack wird jeweils ein Ereignis gefeuert.
Imports System

Imports System.Web.UI
Imports System.Web.UI.WebControls
Imports System.ComponentModel

<DefaultEvent("FuenfPostBacks")> _
Public Class PostbackCounter2
 Inherits WebControl

 ' === Attribut ber die Anzahl erfolgter Postback
 Public Property AnzahlPostBacks() As Integer
  Get
   Dim AnzahlPostBackObject As Object = ViewState("AnzahlPostBacks")
   Dim _AnzahlPostBacks As Integer
   If (AnzahlPostBackObject Is Nothing) Then
    _AnzahlPostBacks = 0
   Else
    _AnzahlPostBacks = CType(AnzahlPostBackObject, Integer)
   End If
   Return _AnzahlPostBacks
  End Get
  Set(ByVal Value As Integer)
   ViewState("AnzahlPostBacks") = Value
  End Set
 End Property

 ' === Ereignis das beim 5. PostBack feuert.
 Public Event FuenfPostBacks As EventHandler

 ' === Ereignis das beim 10. PostBack feuert.
 Public Event ZehnPostBacks As EventHandler

 ' === Verwenden des Load Ereignisses zum Zhlen der Postback
 Private Sub PostBackZaehler_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
  If Me.Parent.Page.IsPostBack Then
   AnzahlPostBacks += 1
  End If

  If AnzahlPostBacks = 5 Then RaiseEvent FuenfPostBacks(Me, e)

  If AnzahlPostBacks = 10 Then RaiseEvent ZehnPostBacks(Me, e)

 End Sub

 ' === Definieren der Darstellung
 Protected Overrides Sub Render(ByVal Ausgabe As HtmlTextWriter)
  ' --- Attribute fr das nchste ffnende Tag erzeugen
  AddAttributesToRender(Ausgabe)
  Ausgabe.RenderBeginTag("span")
  Ausgabe.Write("Anzahl PostBacks = " & AnzahlPostBacks)
  Ausgabe.RenderEndTag()
 End Sub

End Class
