using System;
using System.Web;
using System.Web.Security;
using System.DirectoryServices;
using System.Security.Principal;
/// <summary>
/// Summary description for Authentifierung
/// </summary>

public class WindowsAuthentifizierung
{
  
 // Authentifizierung mit System.DirectoryServices/ADSI
 public static bool IsADSIAuthentifizierbar(string Pfad, string Domain, string BenutzerName, string Kennwort)
 {
  string VollstaendigerBenutzerName = Domain + "\\" + BenutzerName;
  System.Diagnostics.Debug.WriteLine(Pfad);
  DirectoryEntry Eintrag = new DirectoryEntry(Pfad, VollstaendigerBenutzerName, Kennwort);
  try
  {
   System.Diagnostics.Debug.WriteLine(VollstaendigerBenutzerName);
   object Objekt = Eintrag.NativeObject;
   return true;
  }
  catch (Exception Exc)
  {
   System.Diagnostics.Trace.WriteLine(Exc.Message);
   return false;
  }
 }

 // Authentifizierung mit Win32-API
 public static bool IsWin32Authentifizierbar(string Domain, string Benutzername, string Kennwort)
 {
  System.Security.Principal.WindowsIdentity wi = WindowsAuthentifizierung.ImpersonateAnyUser(Benutzername, Domain, Kennwort);
  return (wi != null);
 }
 
 // Hilfsfunktionen aus Win32 API
 [System.Runtime.InteropServices.DllImport("advapi32.dll", EntryPoint = "LogonUser", ExactSpelling = false, CharSet = System.Runtime.InteropServices.CharSet.Auto, SetLastError = true)]
 private static extern int LogonUser(string lpszUsername, string lpszDomain, string lpszPassword, int dwLogonType, int dwLogonProvider, ref IntPtr phToken);
 [System.Runtime.InteropServices.DllImport("advapi32.dll", EntryPoint = "DuplicateToken", ExactSpelling = false, CharSet = System.Runtime.InteropServices.CharSet.Auto, SetLastError = true)]
 private static extern int DuplicateToken(IntPtr ExistingTokenHandle, int ImpersonationLevel, ref IntPtr DuplicateTokenHandle);

 // === Impersonifizieren eines beliebigen Nutzers
 private static System.Security.Principal.WindowsIdentity ImpersonateAnyUser(string userName, string domain, string password)
 {
  int LOGON32_LOGON_INTERACTIVE = 2;
  int LOGON32_PROVIDER_DEFAULT = 0;
  WindowsIdentity WinIdentity;
  IntPtr token = new IntPtr();
  IntPtr token2 = new IntPtr();
  if (LogonUser(userName, domain, password, LOGON32_LOGON_INTERACTIVE, LOGON32_PROVIDER_DEFAULT, ref token) != 0)
  {
   if (DuplicateToken(token, 2, ref token2) != 0)
   {
    WinIdentity = new WindowsIdentity(token2);


    return WinIdentity;
   }
  }
  return null;
 }

}

