using System.Xml;
using System.IO;
using System.Text;
using System.Collections;
using System;

/// <summary>
/// Kapselt den Zugriff auf die Datei counter.xml
/// </summary>
/// <remarks></remarks>
public class XMLCounter_CS
{

 // === Pfad zum XML-Dokument
 public string XmlDatei
 {
  get
  {
   return System.Web.HttpContext.Current.Server.MapPath("~/app_data/counter.xml");
  }
 }

 // === XML Dokument lesen
 public Hashtable Counter_Auslesen()
 {
  XmlDocument doc = new XmlDocument();

  XmlNodeList l = null;
  Hashtable liste = new Hashtable();
  // --- XML-Dokument laden
  doc.Load(this.XmlDatei);
  // --- Elemente auflisten
  l = doc.SelectNodes("*//URL");
  // --- Alle Counter auflisten
  foreach (XmlElement urlElement in l)
  {
   liste.Add(urlElement.Attributes["Name"].Value, urlElement.SelectSingleNode("Count").FirstChild.Value);
  }
  return liste;
 }

 // === ndern des Inhalts
 public long Counter_erhoehen(string CounterName)
 {
  XmlDocument doc = new XmlDocument();
  XmlElement e = null;
  long nw = 0;
  // --- XML-Dokument laden
  doc.Load(this.XmlDatei);
  // --- Einzelnes Element auswhlen
  e = doc.SelectSingleNode("*//URL[@Name='" + CounterName + "']/Count") as XmlElement;
  if (e != null)
  {
   // --- Counter erhhen!
   nw = Convert.ToInt32(e.FirstChild.Value) + 1;
   e.FirstChild.Value = nw.ToString();
   // --- Dokument speichern
   doc.Save(this.XmlDatei);
  }
  else
  {
   Neuer_Counter(CounterName, 1);
   nw = 1;
  }
  return nw;
 }

 // === neuer Counter (Strukturvernderung)
 public void Neuer_Counter(string CounterName, long StartWert)
 {
  XmlDocument doc = new XmlDocument();
  XmlElement newe = null;
  XmlElement e = null;
  XmlAttribute a = null;
  // --- XML-Dokument laden
  doc.Load(this.XmlDatei);
  // --- Startelement suchen
  e = doc.SelectSingleNode("Counter") as XmlElement;
  // --- Neues Element
  newe = doc.CreateNode(XmlNodeType.Element, "URL", "") as XmlElement;
  e.AppendChild(newe);
  // --- Neues Attribut
  a = doc.CreateAttribute("Name");
  a.Value = CounterName;
  newe.SetAttributeNode(a);
  // --- Elternelement wechseln
  e = newe;
  // --- Neues Element
  newe = doc.CreateNode(XmlNodeType.Element, "Aktiv", "") as XmlElement;
  e.AppendChild(newe);
  // --- Neues Element
  newe = doc.CreateNode(XmlNodeType.Element, "Count", "") as XmlElement;
  newe.InnerText = StartWert.ToString();
  e.AppendChild(newe);
  // --- Neues Element
  newe = doc.CreateNode(XmlNodeType.Element, "LastAccess", "") as XmlElement;
  newe.InnerText = DateTime.Now.ToString();
  e.AppendChild(newe);
  // --- Dokument speichern
  doc.Save(this.XmlDatei);
 }

}
