Imports System.Xml
Imports System.IO
Imports System.Text
Imports System.Collections
Imports System

''' <summary>
''' Kapselt den Zugriff auf die Datei counter.xml
''' </summary>
''' <remarks></remarks>
Public Class XMLCounter

 ' === Pfad zum XML-Dokument
 Public ReadOnly Property XmlDatei() As String
  Get
   Return System.Web.HttpContext.Current.Server.MapPath("~/app_data/counter.xml")
  End Get
 End Property

 ' === XML Dokument lesen
 Function Counter_Auslesen() As Hashtable
  Dim doc As New XmlDocument
  Dim urlElement As XmlElement
  Dim l As XmlNodeList
  Dim liste As New Hashtable
  ' --- XML-Dokument laden
  doc.Load(Me.XmlDatei)
  ' --- Elemente auflisten
  l = doc.SelectNodes("*//URL")
  ' --- Alle Counter auflisten
  For Each urlElement In l
   liste.Add(urlElement.Attributes("Name").Value, urlElement.SelectSingleNode("Count").FirstChild.Value)
  Next
  Return liste
 End Function

 ' === ndern des Inhalts
 Function Counter_erhoehen(ByVal CounterName As String) As Long
  Dim doc As New XmlDocument()
  Dim e As XmlElement
  Dim nw As Long
  ' --- XML-Dokument laden
  doc.Load(Me.XmlDatei)
  ' --- Einzelnes Element auswhlen
  e = doc.SelectSingleNode("*//URL[@Name='" & CounterName & "']/Count")
  If e IsNot Nothing Then
   ' --- Counter erhhen!
   nw = e.FirstChild.Value + 1
   e.FirstChild.Value = nw
   ' --- Dokument speichern
   doc.Save(Me.XmlDatei)
  Else
   Neuer_Counter(CounterName, 1)
   nw = 1
  End If
  Return nw
 End Function

 ' === neuer Counter (Strukturvernderung)
 Sub Neuer_Counter(ByVal CounterName As String, ByVal StartWert As Long)
  Dim doc As New XmlDocument()
  Dim newe As XmlElement
  Dim e As XmlElement
  Dim a As XmlAttribute
  ' --- XML-Dokument laden
  doc.Load(Me.XmlDatei)
  ' --- Startelement suchen
  e = doc.SelectSingleNode("Counter")
  ' --- Neues Element
  newe = doc.CreateNode(XmlNodeType.Element, "URL", "")
  e.AppendChild(newe)
  ' --- Neues Attribut
  a = doc.CreateAttribute("Name")
  a.Value = CounterName
  newe.SetAttributeNode(a)
  ' --- Elternelement wechseln
  e = newe
  ' --- Neues Element
  newe = doc.CreateNode(XmlNodeType.Element, "Aktiv", "")
  e.AppendChild(newe)
  ' --- Neues Element
  newe = doc.CreateNode(XmlNodeType.Element, "Count", "")
  newe.InnerText = StartWert
  e.AppendChild(newe)
  ' --- Neues Element
  newe = doc.CreateNode(XmlNodeType.Element, "LastAccess", "")
  newe.InnerText = DateTime.Now
  e.AppendChild(newe)
  ' --- Dokument speichern
  doc.Save(Me.XmlDatei)
 End Sub

End Class
