using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;
using System.Drawing.Imaging;

public partial class Berichte_Flugauslastung_CS : System.Web.UI.Page
{
 protected void Page_Load(object sender, System.EventArgs e)
 {
  this.Page.Title = "Flugauslastungsauswertung fr Abflugort " + this.C_Ablugortauswahl.SelectedValue;
  DiagrammZeichnen(de.WWWings.DAL.Flug_DataManager.AlleFluege_DS(this.C_Ablugortauswahl.SelectedValue).Tables[0]);
 }

 /// <summary>
 /// Diagramm zeichnen
 /// </summary>
 /// <param name="Tabelle"></param>
 /// <remarks></remarks>
 private void DiagrammZeichnen(DataTable Tabelle)
 {
  Graphics Grafik = null;
  Bitmap Bild = null;
  int Zaehler = 0;
  PointF Position = new PointF();
  PointF Position2 = new PointF();
  Rectangle Balken = new Rectangle();
  DataRow Reihe = null;

  // --- Zeichenflche definieren
  Bild = new Bitmap(900, 550);
  Grafik = Graphics.FromImage(Bild);

  // --- Setze den Hintergrund 
  Grafik.Clear(Color.White);

  // --- Logo einfgen
  Bitmap i = new Bitmap(Server.MapPath("~/app_img/WorldWideWings_Logo.jpg"));
  Grafik.DrawImage(i, 5, 5, 200, 70);

  // --- Titel schreiben
  Grafik.DrawString("Flugauslastungsauswertung", new Font("Arial", 14), Brushes.Black, new PointF(240F, 20F));


  const long BasisLinie = 500;
  Position = new PointF(725F, 16F);
  Position2 = new PointF(15F, (float)(BasisLinie));

  int tempFor1 = Tabelle.Rows.Count;
  for (Zaehler = 0; Zaehler < tempFor1; Zaehler++)
  {
   // --- Eingabedaten
   Reihe = Tabelle.Rows[Zaehler];
   // --- Berechnung
   float Plaetze = Convert.ToSingle(Reihe["FL_Plaetze"].ToString());
   float FreiePlaetze = Convert.ToSingle(Reihe["FL_freiePlaetze"].ToString());
   float Aulastung = ((Plaetze - FreiePlaetze) / Plaetze) * 100;

   // --- Legende
   // Rechteck defineren
   Balken.Width = 20;
   Balken.Height = 10;
   Balken.X = 700;
   Balken.Y += 20;
   // Rechteck einrahmen
   Grafik.DrawRectangle(Pens.Black, Balken);
   // Rechteck zeichnen
   Grafik.FillRectangle(new SolidBrush(Colorize(Zaehler)), Balken);
   // Beschriftung der Legende
   Grafik.DrawString(Reihe["Fl_Abflugort"] + "->" + Reihe["Fl_Zielort"], new Font("Arial", 10), Brushes.Black, Position);
   // Ausgabestelle fr Legendenbeschreibung verschieben
   Position.Y += 20;

   // --- Erzeugen des Balkendiagramms
   // Balkenrahmen
   Grafik.DrawRectangle(Pens.Black, (Zaehler * 40) + 15, BasisLinie - Aulastung * 4, 20, Aulastung * 4);
   // Balkeninhalt
   Grafik.FillRectangle(new SolidBrush(Colorize(Zaehler)), (Zaehler * 40) + 15, BasisLinie - Aulastung * 4, 20, Aulastung * 4);
   // Balkenbeschriftung
   Grafik.DrawString(Aulastung.ToString() + "%", new Font("Arial", 9), Brushes.Black, Position2);
   // Position verschieben
   Position2.X += 40;

  }

   string Pfad = "~/berichte/balken_chart_" + this.C_Ablugortauswahl.SelectedValue.Replace("/","_") + ".jpg";
  // --- Speichern des Bitmap-Objektes als JPEG
  Bild.Save(Server.MapPath(Pfad), ImageFormat.Jpeg);
  // --- Setzen des Pfades
  C_Diagramm.ImageUrl = Pfad;
 }

 /// <summary>
 /// Vergabe der Farben
 /// </summary>
 /// <param name="Idx"></param>
 /// <returns></returns>
 /// <remarks></remarks>
 private Color Colorize(int Idx)
 {
  //int farbe = Convert.ToInt32((Convert.ToSingle(Idx) / 15) * System.Int32.MaxValue);
  Color Farbe = Color.FromArgb(255-Idx*15, Idx*10, Idx *15);
  return Farbe;
 }
}
