
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.Configuration
Imports System.Drawing.Rectangle
Imports System.Data

Partial Class Berichte_Imagegenerator_VB
    Inherits System.Web.UI.Page


 ''' <summary>
 ''' Diagramm zeichnen
 ''' </summary>
 ''' <param name="Tabelle"></param>
 ''' <remarks></remarks>
 Private Sub DiagrammZeichnen(ByVal Tabelle As DataTable)
  Dim Grafik As Graphics
  Dim Bild As Bitmap
  Dim Zaehler As Integer
  Dim Position As PointF
  Dim Position2 As PointF
  Dim Balken As Rectangle
  Dim Reihe As DataRow

  ' --- Zeichenflche definieren
        Bild = New Bitmap(700, 550)
  Grafik = Graphics.FromImage(Bild)

  ' --- Setze den Hintergrund 
  Grafik.Clear(Color.White)

  ' --- Logo einfgen
  Dim i As New Bitmap(Server.MapPath("~/app_img/WorldWideWings_Logo.jpg"))
  Grafik.DrawImage(i, 5, 5, 200, 70)

  ' --- Titel schreiben
        Grafik.DrawString("Flugauslastungsauswertung", New Font("Arial", 14), Brushes.Black, New PointF(220, 20))


  Const BasisLinie As Long = 500
        Position = New PointF(525, 16)
  Position2 = New PointF(15, BasisLinie)

  For Zaehler = 0 To Tabelle.Rows.Count - 1
   ' --- Eingabedaten
   Reihe = Tabelle.Rows(Zaehler)
   Dim Aulastung As Long = ((Reihe.Item("FL_Plaetze") - Reihe.Item("FL_freiePlaetze")) / Reihe.Item("FL_Plaetze")) * 100

   ' --- Legende
   ' Rechteck defineren
   Balken.Width = 20
   Balken.Height = 10
            Balken.X = 500
            Balken.Y += 15
   ' Rechteck einrahmen
   Grafik.DrawRectangle(Pens.Black, Balken)
   ' Rechteck zeichnen
   Grafik.FillRectangle(New SolidBrush(Colorize(Zaehler)), Balken)
   ' Beschriftung der Legende
   Grafik.DrawString(Reihe.Item("Fl_Abflugort") & "->" & Reihe.Item("Fl_Zielort"), New Font("Arial", 10), Brushes.Black, Position)
   ' Ausgabestelle fr Legendenbeschreibung verschieben
            Position.Y += 15

   ' --- Erzeugen des Balkendiagramms
   ' Balkenrahmen
            Grafik.DrawRectangle(Pens.Black, (Zaehler * 30) + 15, BasisLinie - Aulastung * 4, 20, Aulastung * 4)
   ' Balkeninhalt
            Grafik.FillRectangle(New SolidBrush(Colorize(Zaehler)), (Zaehler * 30) + 15, BasisLinie - Aulastung * 4, 20, Aulastung * 4)
   ' Balkenbeschriftung
   Grafik.DrawString(Aulastung.ToString() & "%", New Font("Arial", 9), Brushes.Black, Position2)
   ' Position verschieben
            Position2.X += 30

  Next Zaehler

  Response.Clear()
  Response.ContentType = "image/jpeg"

  ' --- Speichern des Bitmap-Objektes als JPEG
  Bild.Save(Response.OutputStream, ImageFormat.Jpeg)

 End Sub



 ''' <summary>
 ''' Vergabe der Farben
 ''' </summary>
 ''' <param name="Idx"></param>
 ''' <returns></returns>
 ''' <remarks></remarks>
 Private Function Colorize(ByVal Idx As Integer) As Color
  Dim Farbe As Color = Color.FromArgb(255 - Idx * 15, Idx * 10, Idx * 15)
  Return Farbe
 End Function

 Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
  ' Daten holen
  Dim dt As DataTable
  dt = de.WWWings.DAL.Flug_DataManager.AlleFluege_DS(Me.Request("Ort")).Tables(0)
  ' Daten anzeigen
  DiagrammZeichnen(dt)
 End Sub
End Class
