using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class RegistrierungDrucken : System.Web.UI.Page
{

 // Rekursiver Durchlauf der PreviousPage und Suchen namentlich passender Steuerelement in der aktuellen Seite
 private void MapControls(Control Quelle, Control Ziel)
 {
  foreach (Control c2 in Quelle.Controls)
  {
   // Suche Steuerelement gleichen Namens
   Label l = Ziel.FindControl(c2.ID) as Label;
   if (l != null)
   {
    if (c2 is TextBox) // Eingabefeld
    {
     l.Text = (c2 as TextBox).Text;
    }
    if (c2 is ListControl) // Listensteuerelement
    {
     l.Text = (c2 as DropDownList).SelectedItem.Text;
    }
   }
   // Rekursiver Aufruf
   MapControls(c2, Ziel);
  }
 }


 protected void Page_Load(object sender, EventArgs e)
 {
  // Gibt es eine vorgehende Seite?
  if (Page.PreviousPage != null)
  {
   // Variante 1: Zugriff ber FindControl()
   this.C_Name.Text = (this.PreviousPage.FindControl("C_Name") as TextBox).Text;
   this.C_Ort.Text = (this.PreviousPage.FindControl("C_Ort") as TextBox).Text;
   // usw.

   // Variante 2: Zugriff ber ffentliche Eigenschaft der Seite auf Steuerelement selbst
   this.C_Name.Text = this.PreviousPage.Name;
   this.C_Ort.Text = this.PreviousPage.Ort;
   // usw.

   // Variante 3: Generische Lsung
   MapControls(this.PreviousPage, this);
  }
  else
  {
   // Steht etwas in den Sitzungsvariablen?
   if (Session["Name"] != null)
   {
    this.C_Name.Text = Session["Name"].ToString();
    this.C_Ort.Text = Session["Ort"].ToString();
   }
   else
   // Steht etwas in der URL?
   {
    if (Request["Name"] != null)
    {
     this.C_Name.Text = Request["Name"].ToString();
     this.C_EMail.Text = Request["EMail"].ToString();
    }
    else
    {
     // Fehleranzeige!
     Response.Write("Es wurden keine Daten bergeben!");
    }
   }
  }
 }
}
