﻿<%@ WebService Language="c#" Class="WWWingsFlugplanService" %>
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System;

[WebService(Namespace = "http://worldwidewings.de/", Name = "WorldWideWings Flugplan-Webservice", Description = "Webservices für den WorldWideWings-Flugplan!"), WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1, EmitConformanceClaims = true)]
[System.Web.Script.Services.ScriptService()]
public class WWWingsFlugplanService : System.Web.Services.WebService
{
 [WebMethod()]
 public de.WWWings.Flug GetFlight(long FlightNo)
 {
  return de.WWWings.FlugBLManager.HoleFlug(FlightNo);
 }

 [WebMethod()]
 public System.Data.DataSet GetAllFlights()
 {
  //Return New Data.DataSet()
  return de.WWWings.DAL.Flug_DataManager.AlleFluege_DS();
 }

 [WebMethod()]
 public de.WWWings.FlugMenge HoleAlle()
 {
  //Return New Data.DataSet()
  return de.WWWings.FlugBLManager.HoleAlle();
 }

 [WebMethod()]
 public de.WWWings.FlugMenge HoleAlleVon(string Ort)
 {
  //Return New Data.DataSet()
  return de.WWWings.FlugBLManager.HoleAlle(Ort);
 }


 [WebMethod()]
 public long GetSeats(long FlightNo)
 {
  return Convert.ToInt64(new de.WWWings.DAL.Flug_DataManager().GetFlug_DR(FlightNo)["Fl_Plaetze"].ToString());
 }


 [WebMethod()]
 public void UpdateFlights(System.Data.DataSet ds)
 {
  de.WWWings.DAL.Flug_DataManager.Update(ds);
 }

 [WebMethod()]

 public string[] GetDestinations(string Abflugort)
 {
  return de.WWWings.FlugBLManager.Ziele_Fuer_Abflugort(Abflugort);
 }

 [WebMethod()]

 public string[] Abflugorte()
 {
  return de.WWWings.FlughaefenBLManager.Abflughaefen();
 }

 [WebMethod(EnableSession = true)]
 public void Zaehler(ref long BenutzerAufrufe, ref long Gesamtaufrufe)
 {
  Session["Counter"] = (long)Session["Counter"] + 1;
  Application["Counter"] = (long)Application["Counter"] + 1;
  BenutzerAufrufe = (long)Session["Counter"];
  Gesamtaufrufe = (long)Application["Counter"];
 }

 [WebMethod(EnableSession = true)]
 public de.WWWings.MitarbeiterSystem.Mitarbeiterzuordnung<de.WWWings.MitarbeiterSystem.Pilot, de.WWWings.MitarbeiterSystem.Pilot> PilotCoPilotZuordnung(de.WWWings.MitarbeiterSystem.Pilot Pilot, de.WWWings.MitarbeiterSystem.Pilot Copilot)
 {

  de.WWWings.MitarbeiterSystem.Mitarbeiterzuordnung<de.WWWings.MitarbeiterSystem.Pilot, de.WWWings.MitarbeiterSystem.Pilot> mz = new de.WWWings.MitarbeiterSystem.Mitarbeiterzuordnung<de.WWWings.MitarbeiterSystem.Pilot, de.WWWings.MitarbeiterSystem.Pilot>(Pilot, Copilot);
  return mz;
 }
}