﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI
{
 public partial class F_Hauptmenu : Form
 {
  public F_Hauptmenu()
  {
   InitializeComponent();
  }

  private Boolean Online = true;
  private Boolean LastOnline = false;

  private void RefreshUI()
  {

   //  Server Status

   de.WWWings.WCF.PingInfo pi = null;
   Exception ex = null;
   int Milliseconds = 0;
   CallCenterApp.Dienste.PingServer(ref pi, ref Milliseconds,ref ex);

   if (pi == null)
   {
    this.C_Status.Text = "Keine Verbindung. Bitte starten Sie den WCF-Server als Systemdienst oder Konsolenanwendung";
    this.C_Status.Tag = ex;
    this.C_Status.ForeColor = System.Drawing.Color.Red;
    this.C_StatusAppServer.Text = "Nicht verbunden";
    this.C_StatusAppServer.ForeColor = System.Drawing.Color.Red;
    this.C_ServerVersion.Text = "...";
    this.C_Identitaet.Text = "...";
    this.C_AnzFluege.Text = "...";
    this.C_AnzPassagiere.Text = "...";
    this.C_AnzBuchungen.Text = "...";
    Online = false;
   }
   else
   {
    this.C_Status.Tag = null;
    this.C_Status.Text = "Verbindung zum Application Server " + pi.ComputerName + " über " + WindowsUI.Properties.Settings.Default.Kommunikationsprofil + ". Ping-Zeit: " + Milliseconds + " Millisekunden.";
    this.C_Status.ForeColor = System.Drawing.Color.Green;
    this.C_StatusAppServer.Text = "Verbunden";
    this.C_StatusAppServer.ForeColor = System.Drawing.Color.Green;
    this.C_ServerVersion.Text = pi.Version.ToString();
     this.C_Identitaet.Text = pi.ServerIdentity;

    this.C_AnzFluege.Text = pi.DBInfo.AnzFluege.ToString();
    this.C_AnzPassagiere.Text = pi.DBInfo.AnzPassagiere.ToString();
    this.C_AnzBuchungen.Text = pi.DBInfo.AnzBuchungen.ToString();
    Online = true;
   }

   if (Online != LastOnline)
   {
    this.C_Notify.ShowBalloonTip(1000, "World Wide Wings", "Der Status der Anwendung hat sich geändert.", ToolTipIcon.Info);
    LastOnline = Online;
   }


   // Statusfenster
   RefreshMDIWindows();

   // Menü

   this.englischToolStripMenuItem.Checked = !(WindowsUI.Properties.Settings.Default.Sprache == "de-DE");
   this.deutschToolStripMenuItem.Checked = (WindowsUI.Properties.Settings.Default.Sprache == "de-DE");

   // Client Status
   this.C_AppServer.Text = WindowsUI.Properties.Settings.Default.AppServer;
   this.C_Benutzername.Text = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
   this.C_Anmeldungen.Text = WindowsUI.Properties.Settings.Default.AnzahlAufrufeDiesesNutzers.ToString();
   this.C_LetzteAnmeldung.Text = WindowsUI.Properties.Settings.Default.LetzterAufruf.ToString();
   this.C_Sprache.Text = System.Threading.Thread.CurrentThread.CurrentUICulture.NativeName;
   this.C_StyleInfo.Text = System.Windows.Forms.VisualStyles.VisualStyleInformation.DisplayName + ";" + System.Windows.Forms.VisualStyles.VisualStyleInformation.Company;

   this.C_StatusBenutzer.Text = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
   this.C_StatusSprache.Text = System.Threading.Thread.CurrentThread.CurrentUICulture.NativeName;
   this.C_Version.Text = System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString();
  }

  private void Hauptmenu_Load(object sender, EventArgs e)
  {

   WindowsUI.Properties.Settings.Default.AnzahlAufrufeDiesesNutzers += 1;
   WindowsUI.Properties.Settings.Default.LetzterAufruf = System.DateTime.Now;
   WindowsUI.Properties.Settings.Default.Save();

   System.Media.SystemSounds.Beep.Play();

   RefreshUI();
  }


  public void RefreshMDIWindows()
  {
   // Ausblenden des Inhalts des MDI-Elternfensters
   this.C_MainPanel.Visible = !(this.MdiChildren.Length > 0);

   //this.C_Fenster.Items.Clear();

   //foreach (Form f in this.MdiChildren)
   //{
   // this.C_Fenster.Items.Add(f.Text);
   //}
  }

  private void Hauptmenu_FormClosed(object sender, FormClosedEventArgs e)
  {
   //Application.Exit();
  }

  private void button1_Click(object sender, EventArgs e)
  {
   this.Controls["GroupBox1"].BackColor = Color.Azure;
   this.Controls[0].BackColor = Color.Azure;
  }

  private void F_Hauptmenu_Load(object sender, EventArgs e)
  {

  }

  private void ticketdruckenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   //new Demos().TicketDruck();
  }



  private void windowsSpracheToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void FormularNeuZeichnen()
  {
   this.Controls.Clear();

   this.InitializeComponent();
  }


  private void englischToolStripMenuItem_Click(object sender, EventArgs e)
  {


  }

  private void fluglistepflegenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_Flugverwaltung_RAD_TDS().Show();
  }

  private void fluglistemanuelleDatenbindungToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_Flugverwaltung_Manuell().Show();
  }

  private void mitarbeiterzuordnungToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void buchungslisteToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new F_Buchungsverwaltung().ShowDialog();
  }

  private void mDIAnsichtToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new F_MDI().Show();
  }

  private void xPVisualStylesToolStripMenuItem_Click(object sender, EventArgs e)
  {
   //xPVisualStylesToolStripMenuItem.Checked = !xPVisualStylesToolStripMenuItem.Checked;
   //if (xPVisualStylesToolStripMenuItem.Checked)
   //{
   // Application.EnableVisualStyles();
   //}
   //else
   //{
   // Application.EnableVisualStyles();
   //}



  }

  private void aToolStripMenuItem_Click(object sender, EventArgs e)
  {



  }

  private void hToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void flowToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_FlowLayoutTest().ShowDialog();
  }

  private void tableToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_TableLayoutTest().ShowDialog();
  }

  private void benutzerdefDatenbindungToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_Binding().ShowDialog();
  }

  private void passagierpflegeObjektbindungToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_ObjektBindung().ShowDialog();
  }

  private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
  {
   // This method will run on a thread other than the UI thread.
   // Be sure not to manipulate any Windows Forms controls created
   // on the UI thread from this method.

  }

  private void backgroundWorkerToolStripMenuItem_Click(object sender, EventArgs e)
  {
   //this.backgroundWorker1.RunWorkerAsync();
  }

  private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
  {
   System.Windows.Forms.MessageBox.Show("Ich habe fertig!");
  }

  private void bewertungenToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void toolStripButton1_Click(object sender, EventArgs e)
  {

  }

  private void userLevelToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_UserLevelKonfig().ShowDialog();
  }

  private void beendenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   DialogResult a = System.Windows.Forms.MessageBox.Show("Wollen Sie die Anwendung wirklich beenden?", Application.ProductName, MessageBoxButtons.YesNo);
   if (a == DialogResult.Yes)
   {
    Application.Exit();
   }
  }

  private void berichtdruckenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   //new Fenster.F_Flugberichtansicht().Show();
  }

  private void berichtdruckenMSReportsToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_Flugberichtansicht_MSReports().Show();
  }

  private void anzeigeEingehendeFluegeToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_Flugliste_MitAktualisierung().Show();
  }

  private void groupBox1_Enter(object sender, EventArgs e)
  {

  }

  private void hilfeToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void tableLayoutToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void fluglisteObjektdatenbindungToolStripMenuItem_Click(object sender, EventArgs e)
  {
   Fensterverwaltung.ZeigeFenster(new Fenster.F_Flugverwaltung_Object());


  }

  private void fluglisteWebserviceToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new F_Flugverwaltung_Webservice().Show();
  }

  private void fluglisteMitDetailansichtRADTypedDataSetToolStripMenuItem_Click(object sender, EventArgs e)
  {
   System.Windows.Forms.MessageBox.Show("Leider noch nicht implementiert!");
   //new Fenster.F_Flugverwaltung_mit_Details_RAD_TDS().Show();
  }

  private void activeXHostingToolStripMenuItem_Click(object sender, EventArgs e)
  {
   //Fenster.F_ActiveXHosting f = new WindowsUI.Fenster.F_ActiveXHosting();
   //f.Show();
  }

  private void einstellungenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new CallCenterApp.F_Konfiguration().ShowDialog();

  }

  private void buchungErstellenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new CallCenterApp.F_Buchung().Show();
  }

  private void datenbankZurücksetzenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   if (MessageBox.Show("Wollen Sie die Datenbank wirklich auf den Ausgangszustand zurücksetzen?", "Bestätigung", MessageBoxButtons.YesNo) == DialogResult.Yes)
   {
    de.WWWings.Test.InitDatabase.Init();

    MessageBox.Show("Datenbank wurde zurückgesetzt!", "Erledigt", MessageBoxButtons.OK);
   }
  }

  private void konfigurationToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void schreibschutzmodusToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void toolStripMenuItem2_Click(object sender, EventArgs e)
  {
   string Sprache = "de-DE";
   Fensterverwaltung.SpracheSetzen(Sprache);
   this.FormularNeuZeichnen();
   RefreshUI();


  }

  private void englischToolStripMenuItem1_Click(object sender, EventArgs e)
  {

   string Sprache = "en-GB";
   Fensterverwaltung.SpracheSetzen(Sprache);
   this.FormularNeuZeichnen();
   RefreshUI();
  }



  private void buchungErstellenToolStripMenuItem1_Click(object sender, EventArgs e)
  {
   CallCenterApp.F_Buchung f = new CallCenterApp.F_Buchung();
   f.MdiParent = this;
   f.Show();
   RefreshMDIWindows();
  }

  private void flügeVerwaltenToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void passagierePflegenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   CallCenterApp.F_Passagier f = new CallCenterApp.F_Passagier();
   f.MdiParent = this;
   f.Show();
   RefreshMDIWindows();
  }

  private void C_Timer_Tick(object sender, EventArgs e)
  {
   RefreshUI();

  }

  private void konfigurationToolStripMenuItem_Click_1(object sender, EventArgs e)
  {
   CallCenterApp.F_Konfiguration f = new CallCenterApp.F_Konfiguration();
   f.MdiParent = this;
   f.Show();
   RefreshMDIWindows();
  }

  private void aToolStripMenuItem1_Click(object sender, EventArgs e)
  {
   System.Media.SoundPlayer p = new System.Media.SoundPlayer();
   p.SoundLocation = @"..\..\Media\a.wav";
   p.Play();
  }

  private void hToolStripMenuItem1_Click(object sender, EventArgs e)
  {

   System.Media.SoundPlayer p = new System.Media.SoundPlayer();
   p.SoundLocation = @"..\..\Media\h.wav";
   p.Play();

  }

  private void vertikalToolStripMenuItem_Click(object sender, EventArgs e)
  {
   LayoutMdi(MdiLayout.TileVertical);
  }


  private void TileHorizontalToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }


  private void horizontalToolStripMenuItem_Click(object sender, EventArgs e)
  {
   LayoutMdi(MdiLayout.TileHorizontal);
  }

  private void symboleToolStripMenuItem_Click(object sender, EventArgs e)
  {
   LayoutMdi(MdiLayout.ArrangeIcons);
  }

  private void alleSchließenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   foreach (Form childForm in MdiChildren)
   {
    childForm.Close();
   }
  }

  private void kaskadierenToolStripMenuItem_Click(object sender, EventArgs e)
  {
   LayoutMdi(MdiLayout.Cascade);
  }

  private void pictureBox1_Click(object sender, EventArgs e)
  {

  }

  private void label4_Click(object sender, EventArgs e)
  {

  }

  private void groupBox1_Enter_1(object sender, EventArgs e)
  {

  }

  private void flügeVerwaltenToolStripMenuItem1_Click(object sender, EventArgs e)
  {
   CallCenterApp.F_Flugverwaltung f = new CallCenterApp.F_Flugverwaltung();
   f.MdiParent = this;
   f.Show();
   RefreshMDIWindows();
  }

  private void einstellungenToolStripMenuItem1_Click(object sender, EventArgs e)
  {
   CallCenterApp.F_Konfiguration f = new CallCenterApp.F_Konfiguration();
   f.MdiParent = this;
   f.Show();
   RefreshMDIWindows();
  }

  private void buchungsassistentWorkflowToolStripMenuItem_Click(object sender, EventArgs e)
  {
   de.WWWings.Workflow.WorkflowHost.Start();
  }

  private void mitarbeiterzuordnungDragDropDemoToolStripMenuItem_Click(object sender, EventArgs e)
  {
   Fensterverwaltung.ZeigeFenster(new F_Mitarbeiterzuordnung());
  }

  private void C_AppServer_Click(object sender, EventArgs e)
  {

  }

  private void C_Status_Click(object sender, EventArgs e)
  {
   if (C_Status.Tag != null) Fensterverwaltung.Zeige_Fehler(((Exception)C_Status.Tag));
  }
 }



}
