using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI.CallCenterApp
{
 public partial class F_Passagier : Form
 {
  public F_Passagier()
  {
   InitializeComponent();
  }

  private void F_Passagier_Load(object sender, EventArgs e)
  {
   de.WWWings.WCF.Passagier[] pp = Dienste.PassagierverwaltungServiceClient.HoleAllePassagiere();
   this.passagierBindingSource.DataSource = pp;
   Refresh();
  }

  private void bindingNavigatorMovePreviousItem_Click(object sender, EventArgs e)
  {
   Refresh();
  }

  private void bindingNavigatorMoveNextItem_Click(object sender, EventArgs e)
  {
   Refresh();
  }

  private void Refresh()
  {
   // Liste leeren
   this.C_Fluege.Items.Clear();

   // Aktuelle Passagier ermitteln
   de.WWWings.WCF.Passagier p = this.passagierBindingSource.Current as de.WWWings.WCF.Passagier;

   // Liste neu befllen
   de.WWWings.WCF.Buchung[] bb = Dienste.BuchungsServiceClient.HoleBuchungenFuerPassagier(p.PID);
   foreach (de.WWWings.WCF.Buchung b in bb)
   {
    foreach (de.WWWings.WCF.Flug f in b.Fluege)
    {
     ListViewItem l = new ListViewItem(b.buchungscode.ToString());
     l.Tag = b.buchungscode.ToString();
     l.ImageIndex = 0;
     //ListViewItem.ListViewSubItem c = new ListViewItem.ListViewSubItem(l, b.buchungscode.ToString());
     ListViewItem.ListViewSubItem n = new ListViewItem.ListViewSubItem(l, f.flugNr.ToString());
     ListViewItem.ListViewSubItem s = new ListViewItem.ListViewSubItem(l, f.abflugOrt + "->" + f.zielOrt);
     ListViewItem.ListViewSubItem d = new ListViewItem.ListViewSubItem(l, f._Datum.ToString());
     //l.SubItems.Add(c);
     l.SubItems.Add(n);
     l.SubItems.Add(s);
     l.SubItems.Add(d);
     this.C_Fluege.Items.Add(l);
    }
   }

  }

  private void passagierBindingNavigatorSaveItem_Click(object sender, EventArgs e)
  {
   de.WWWings.WCF.Passagier p = this.passagierBindingSource.Current as de.WWWings.WCF.Passagier;
   // TODO:    Dienste.PassagierverwaltungServiceClient

   this.C_Status.Text = "Passagier " + p.PID + " gespeichert!";
  }

  private void button2_Click(object sender, EventArgs e)
  {
   if (this.C_Fluege.CheckedItems.Count == 0)
   {
    MessageBox.Show("Sie mssen zuerst Buchungen auswhlen!", "Bedienungsfehler");
    return;
   }
   string ausgabe = "";
   // Schleife ber ausgewhlte Elemente
   foreach (ListViewItem l in this.C_Fluege.CheckedItems)
   {
    long BuchungsCode = Convert.ToInt64(l.Tag);
    Dienste.BuchungsServiceClient.BuchungenLoeschen(BuchungsCode);
    ausgabe += BuchungsCode.ToString() + " ";
   }
   this.C_Status.Text = "Buchungen gelscht: " + ausgabe;
   Refresh();
  }


  private void button3_Click(object sender, EventArgs e)
  {
   de.WWWings.WCF.Passagier p = this.passagierBindingSource.Current as de.WWWings.WCF.Passagier;
   Dienste.BuchungsServiceClient.AlleBuchungenLoeschenFuerPassagier(p.PID);
   this.C_Status.Text = "Alle Buchungen gelscht!";
   Refresh();
  }

  private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
  {
   switch (this.comboBox1.Text)
   {
    case "Liste": this.C_Fluege.View = View.List; break;
    case "Details": this.C_Fluege.View = View.Details; break;
    case "Symbole": this.C_Fluege.View = View.SmallIcon; break;
   }
  }

  private void C_TicketDruck_Click(object sender, EventArgs e)
  {

   if (this.C_Fluege.CheckedItems.Count != 1)
   {
    MessageBox.Show("Sie mssen bitte genau eine Buchungen auswhlen!", "Bedienungsfehler");
    return;
   }

   long BuchungsCode = Convert.ToInt64(this.C_Fluege.CheckedItems[0].Tag);

   Fensterverwaltung.Zeige_Ticketdruck(BuchungsCode);
  }



  private void C_Beenden_Click(object sender, EventArgs e)
  {
   this.Close();
  }

  private void button1_Click(object sender, EventArgs e)
  {

   // Aktuelle Passagier ermitteln
   de.WWWings.WCF.Passagier p = this.passagierBindingSource.Current as de.WWWings.WCF.Passagier;

   CallCenterApp.F_Buchung b = new F_Buchung();
   b.PID = p.PID;
   b.Show();
  }
 }
}