﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI
{
 public partial class F_Ticketdruck : Form
 {
  public F_Ticketdruck()
  {
   InitializeComponent();
  }

  //public de.WWWings.PassagierSystem.Buchung Buchung;
  public de.WWWings.WCF.Buchung Buchung;

 
  private void F_Ticketdruck_Paint(object sender, PaintEventArgs e)
  {
   Graphics g = e.Graphics;
  new CallCenter.Zeichnen().TicketZeichnen(Buchung,g);
  }

  private void C_Ticketdruck_Click(object sender, EventArgs e)
  {
   PrintPreviewDialog ppd = new PrintPreviewDialog();
   ppd.Document = this.C_Print;
   if (ppd.ShowDialog() == DialogResult.OK)
   {
    PrintDialog pd = new PrintDialog();
    pd.Document = this.C_Print;
    if (pd.ShowDialog() == DialogResult.OK)
    {
     C_Print.Print();
    }

   }
  }

  private void C_Print_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
  {
   Graphics g = e.Graphics;
   new CallCenter.Zeichnen().TicketZeichnen(Buchung, g);
  }

  private void F_Ticketdruck_Load(object sender, EventArgs e)
  {

  }


  private void C_Zwischenablage_Click(object sender, EventArgs e)
  {
   Clipboard.SetText("Flugticket " + Buchung.buchungscode + "; Name: " + Buchung.Passagier._Nachname + "; Flug: " + Buchung.Fluege[0].ToString());
  }

  private void C_TicketZwischenablage_Click(object sender, EventArgs e)
  {
   Bitmap b = new Bitmap(750, 250);
   new CallCenter.Zeichnen().TicketZeichnen(Buchung, Graphics.FromImage(b));
   Clipboard.SetImage(b);
   b.Dispose();


  }

  private void C_Speichern_Click(object sender, EventArgs e)
  {
   Bitmap b = new Bitmap(750, 250);
   new CallCenter.Zeichnen().TicketZeichnen(Buchung, Graphics.FromImage(b));
   SaveFileDialog sfd = new SaveFileDialog();
   sfd.Filter = "Bitmap (.bmp) | *.bmp";
   sfd.FileName = "Ticket.bmp";
   sfd.InitialDirectory = "c:\\";
   if (sfd.ShowDialog() == DialogResult.OK)
   {
    b.Save("c:\\ticket.bmp");
   }
   b.Dispose();
  }
 }
}