using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
namespace WindowsUI
{
 public static class Fensterverwaltung
 {

  public static void Zeige_Ticketdruck(long BuchungsCode)
  {
   de.WWWings.WCF.Buchung[] b = CallCenterApp.Dienste.BuchungsServiceClient.HoleBuchungen(BuchungsCode);
   if (b.Length > 0)
   {
    F_Ticketdruck DruckFenster = new F_Ticketdruck();
    DruckFenster.Buchung = b[0];
    DruckFenster.ShowDialog();
   }
  }

  public static string HoleFehlerText(Exception ex)
  {
   string ausgabe = ex.GetType().ToString() + ": " + ex.Message + "\n";
   if (ex.InnerException != null) ausgabe += HoleFehlerText(ex.InnerException);
   return ausgabe;
  }

  public static void Zeige_Fehler(Exception ex)
  {
   MessageBox.Show("Es ist ein Fehler aufgetreten:\n----------\n" + HoleFehlerText(ex), "Anwendungsfehler");

  }

  public static void ZeigeFenster(Form f)
  {

   try
   {
   f.ShowDialog();
   }
   catch (Exception ex)
   {
    Zeige_Fehler(ex);
   }

  }

  public static void ZeigeKindFenster(Form Vater, Form Kind)
  {

  }

  public static void SpracheSetzen(string Sprache)
  {
   System.Threading.Thread.CurrentThread.CurrentUICulture = new System.Globalization.CultureInfo(Sprache);
   System.Threading.Thread.CurrentThread.CurrentCulture = new System.Globalization.CultureInfo(Sprache);

   WindowsUI.Properties.Settings.Default.Sprache = Sprache;
   WindowsUI.Properties.Settings.Default.Save();
  }
 }
}
