using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;


namespace WebWork.Ix.VsAddins.RearrangeImportStatementsAddin
{
    public class OrderPositionSection : ConfigurationSection
    {
        OrderPositionConfigElement m_Element;

        public OrderPositionSection()
        {
            m_Element = new OrderPositionConfigElement();
        }

        [ConfigurationProperty("orderPositions", IsDefaultCollection = false)]
        [ConfigurationCollection(typeof(OrderPositionCollection),
            AddItemName = "add",
            ClearItemsName = "clear",
            RemoveItemName = "remove")]
        public OrderPositionCollection OrderPositions
        {
            get
            {
                OrderPositionCollection orderPositionCollection =
                (OrderPositionCollection)base["orderPositions"];
                return orderPositionCollection;
            }
        }
    }

    public class OrderPositionCollection : ConfigurationElementCollection
    {
        public OrderPositionCollection()
        {
            OrderPositionConfigElement orderPosition = (OrderPositionConfigElement)CreateNewElement();
            Add(orderPosition);
        }

        public override ConfigurationElementCollectionType CollectionType
        {
            get
            {
                return ConfigurationElementCollectionType.AddRemoveClearMap;
            }
        }

        protected override ConfigurationElement CreateNewElement()
        {
            return new OrderPositionConfigElement();
        }

        protected override Object GetElementKey(ConfigurationElement element)
        {
            return ((OrderPositionConfigElement)element).Key;
        }

        public OrderPositionConfigElement this[int index]
        {
            get
            {
                return (OrderPositionConfigElement)BaseGet(index);
            }
            set
            {
                if (BaseGet(index) != null)
                {
                    BaseRemoveAt(index);
                }
                BaseAdd(index, value);
            }
        }

        new public OrderPositionConfigElement this[string key]
        {
            get
            {
                return (OrderPositionConfigElement)BaseGet(key);
            }
        }

        public int IndexOf(OrderPositionConfigElement element)
        {
            return BaseIndexOf(element);
        }

        public void Add(OrderPositionConfigElement element)
        {
            BaseAdd(element);
        }
        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        public void Remove(OrderPositionConfigElement element)
        {
            if (BaseIndexOf(element) >= 0)
                BaseRemove(element.Key);
        }

        public void RemoveAt(int index)
        {
            BaseRemoveAt(index);
        }

        public void Remove(string key)
        {
            BaseRemove(key);
        }

        public void Clear()
        {
            BaseClear();
        }
    }

    public class OrderPositionConfigElement : ConfigurationElement
    {
        public OrderPositionConfigElement(string searchText, string orderText)
        {
            this.SearchText = searchText;
            this.OrderText = orderText;
        }

        public OrderPositionConfigElement() { }

        public string Key
        {
            get { return SearchText; }
        }

        [ConfigurationProperty("searchText", IsRequired = true, IsKey = true)]
        public string SearchText
        {
            get
            {
                return (string)this["searchText"];
            }
            set
            {
                this["searchText"] = value;
            }
        }

        [ConfigurationProperty("orderText", IsRequired = false, IsKey = false)]
        public string OrderText
        {
            get
            {
                return (string)this["orderText"];
            }
            set
            {
                this["orderText"] = value;
            }
        }
    }

}
