
# Parameters
$PROVIDER = "System.Data.SqlClient"
$CONNSTRING = "Data Source=.\SQLEXPRESS;AttachDbFileName=H:\demo\PowerShell\Datenbanken\users.mdf;Integrated Security=True;"
$SQL = "Select * from users"

# Create Factory
$provider = [System.Data.Common.DbProviderFactories]::GetFactory($PROVIDER)

# Create Connection
$conn = $provider.CreateConnection()
$conn.ConnectionString = $CONNSTRING

# Open Connection
$conn.Open();
"Zustand der Datenbank: " + $conn.State

# Create Command
$cmd = $provider.CreateCommand()
$cmd.CommandText = $SQL
$cmd.Connection = $conn

# Create Adapter
[System.Data.Common.DbDataAdapter] $ada = $provider.CreateDataAdapter()
$ada.SelectCommand = $cmd

# Create Dataset
$ds = New-Object System.Data.DataSet

# Retrieve data
$e = $ada.Fill($ds, "Benutzer") 

# Datenbank schließen
$Conn.Close()
"Zustand der Datenbank: " + $conn.State

# Output
"Number of Tables: " + $ds.Tables.Count
"Number of Rows in Table 1: " + $ds.Tables[0].Rows.Count

# Access table
$Tabelle = $ds.Tables[0]

# Print all rows
"Rows:"
$Tabelle | Select UserFirstName, UserSurname, userid



