/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.ParserPlugin;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.io.FileReaderSource;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.io.StringReaderSource;
import org.codehaus.groovy.control.io.URLReaderSource;
import org.codehaus.groovy.control.messages.LocatedMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.Reduction;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.parser.UnexpectedTokenException;
import org.codehaus.groovy.tools.Utilities;

public class SourceUnit
extends ProcessingUnit {
    private ParserPlugin parserPlugin;
    protected ReaderSource source;
    protected String name;
    protected Reduction cst;
    protected ModuleNode ast;

    public SourceUnit(String name, ReaderSource source, CompilerConfiguration flags, ClassLoader loader) {
        super(flags, loader);
        this.name = name;
        this.source = source;
    }

    public SourceUnit(File source, CompilerConfiguration configuration, ClassLoader loader) {
        this(source.getPath(), new FileReaderSource(source, configuration), configuration, loader);
    }

    public SourceUnit(URL source, CompilerConfiguration configuration, ClassLoader loader) {
        this(source.getPath(), new URLReaderSource(source, configuration), configuration, loader);
    }

    public SourceUnit(String name, String source, CompilerConfiguration configuration, ClassLoader loader) {
        this(name, new StringReaderSource(source, configuration), configuration, loader);
    }

    public String getName() {
        return this.name;
    }

    public Reduction getCST() {
        return this.cst;
    }

    public ModuleNode getAST() {
        return this.ast;
    }

    public boolean failedWithUnexpectedEOF() {
        Token unexpected;
        SyntaxException cause;
        Message last;
        boolean result = false;
        if (this.errors != null && (last = (Message)this.errors.get(this.errors.size() - 1)) instanceof SyntaxErrorMessage && (cause = ((SyntaxErrorMessage)last).getCause()) instanceof UnexpectedTokenException && (unexpected = ((UnexpectedTokenException)cause).getUnexpectedToken()).isA(-1)) {
            result = true;
        }
        return result;
    }

    public static SourceUnit create(String name, String source) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setTolerance(1);
        return new SourceUnit(name, source, configuration, null);
    }

    public static SourceUnit create(String name, String source, int tolerance) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setTolerance(tolerance);
        return new SourceUnit(name, source, configuration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse() throws CompilationFailedException {
        if (this.phase > 2) {
            throw new GroovyBugError("parsing is already complete");
        }
        if (this.phase == 1) {
            this.nextPhase();
        }
        Reader reader = null;
        reader = this.source.getReader();
        this.parserPlugin = this.getConfiguration().getPluginFactory().createParserPlugin();
        this.cst = this.parserPlugin.parseCST(this, reader);
        this.completePhase();
        Object var4_2 = null;
        if (reader == null) return;
        try {
            reader.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                this.addFatalError(new SimpleMessage(e.getMessage()));
                Object var4_3 = null;
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void convert() throws CompilationFailedException {
        if (this.phase == 2 && this.phaseComplete) {
            this.gotoPhase(3);
        }
        if (this.phase != 3) {
            throw new GroovyBugError("SourceUnit not ready for convert()");
        }
        try {
            this.ast = this.parserPlugin.buildAST(this, this.classLoader, this.cst);
            this.ast.setDescription(this.name);
        }
        catch (SyntaxException e) {
            this.addError(new SyntaxErrorMessage(e));
        }
        this.completePhase();
    }

    public void addWarning(int importance, String text, CSTNode context) {
        if (WarningMessage.isRelevant(importance, this.warningLevel)) {
            this.addWarning(new WarningMessage(importance, text, context));
        }
    }

    public void addWarning(int importance, String text, Object data, CSTNode context) {
        if (WarningMessage.isRelevant(importance, this.warningLevel)) {
            this.addWarning(new WarningMessage(importance, text, data, context));
        }
    }

    public void addError(SyntaxException error) throws CompilationFailedException {
        this.addError(Message.create(error), error.isFatal());
    }

    public void addError(String text, CSTNode context) throws CompilationFailedException {
        this.addError(new LocatedMessage(text, context));
    }

    public String getSample(int line, int column, Janitor janitor) {
        String sample = null;
        String text = this.source.getLine(line, janitor);
        if (text != null) {
            if (column > 0) {
                String marker = Utilities.repeatString(" ", column - 1) + "^";
                if (column > 40) {
                    int start = column - 30 - 1;
                    int end = column + 10 > text.length() ? text.length() : column + 10 - 1;
                    sample = "   " + text.substring(start, end) + Utilities.eol() + "   " + marker.substring(start, marker.length());
                } else {
                    sample = "   " + text + Utilities.eol() + "   " + marker;
                }
            } else {
                sample = text;
            }
        }
        return sample;
    }

    public static ModuleNode createModule(String code) throws CompilationFailedException {
        SourceUnit su = SourceUnit.create("NodeGen", code);
        su.parse();
        su.convert();
        return su.getAST();
    }

    public static ClassNode createClassNode(String code) throws CompilationFailedException {
        ModuleNode module = SourceUnit.createModule(code);
        List classes = module.getClasses();
        if (classes.size() > 1) {
            throw new RuntimeException("The code defines more than one class");
        }
        return (ClassNode)classes.get(0);
    }

    public static FieldNode createFieldNode(String code) throws CompilationFailedException {
        ClassNode classNode = SourceUnit.createClassNode(SourceUnit.wrapCode(code));
        List flds = classNode.getFields();
        if (flds.size() > 1) {
            throw new RuntimeException("The code defines more than one field");
        }
        return (FieldNode)flds.get(0);
    }

    public Statement createStatement(String code) throws CompilationFailedException {
        ModuleNode module = SourceUnit.createModule(code);
        BlockStatement block = module.getStatementBlock();
        if (block == null) {
            throw new RuntimeException("no proper statement block is created.");
        }
        List stats = block.getStatements();
        if (stats == null || stats.size() != 1) {
            throw new RuntimeException("no proper statement node is created.");
        }
        return (Statement)stats.get(0);
    }

    public MethodNode createMethodNode(String code) throws CompilationFailedException {
        ModuleNode module;
        List ms;
        if ((code = code.trim()).indexOf("def") != 0) {
            code = "def " + code;
        }
        if ((ms = (module = SourceUnit.createModule(code)).getMethods()) == null || ms.size() != 1) {
            throw new RuntimeException("no proper method node is created.");
        }
        return (MethodNode)ms.get(0);
    }

    private static String wrapCode(String code) {
        String prefix = "class SynthedClass {\n";
        String suffix = "\n }";
        return prefix + code + suffix;
    }
}

