package de.schoeso.application.web.library.entity;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Version;

/**
 * Buckatalog einer Bibliothek
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */
@NamedQuery(name="getAllCatalogs",
		query="SELECT catalog FROM LibraryCatalog AS catalog ORDER BY catalog.catalogname DESC")

@SuppressWarnings("serial")
@Entity
@SequenceGenerator(name="libcatseq", initialValue=1, sequenceName="libcatseq", allocationSize=1)
public class LibraryCatalog implements Serializable {
	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator="libcatseq")
	private long catalogid;     // Primrschlssel	
	@Version
	private int version;        // Version fr Optimisic Locking

	private String catalogname; 

  @OneToMany(mappedBy="catalog")
	private Collection<LibraryItem> items = new HashSet<LibraryItem>();
	
	public LibraryCatalog() {
	}
  // ==== simple get/set
	public String getCatalogname() {
		return catalogname;
	}
	public void setCatalogname(String catalogname) {
		this.catalogname = catalogname;
	}
	public long getCatalogid() {
		return catalogid;
	}
	public void setCatalogid(long catalogid) {
		this.catalogid = catalogid;
	}
	public int getVersion() {
		return version;
	}
	/** Wird nur fr das Optimistic Locking verwendet und darf nicht gelesen werden */
	@SuppressWarnings("unused")
	private void setVersion(int version) {
		this.version = version;
	}
	// ========================
	public Collection<LibraryItem> getItems() {
		return items;
	}
	public void setItems(Collection<LibraryItem> items) {
		this.items = items;
	}
	// ========================
	/** Dursucht den Katalog - Zeichenketten werden ohne Vergleich auf gross/Klein durchsucht 
	 * @param titlesubstring zu suchender Teilstring
	 */ 
	public Collection<LibraryItem> search(String titlesubstring) {
		Collection<LibraryItem> res = new Vector<LibraryItem>();
		for (LibraryItem item : getItems()) {
			if (item.getTitle().toUpperCase().indexOf(titlesubstring.toUpperCase()) > -1) {
				res.add(item);
			}
		}
		return res;
	}
	// ========================
	/** zustzlich sollte hier auch hashCode() berschrieben werden */
	@Override
	public boolean equals(Object obj) {
		if (obj != null && obj instanceof LibraryCatalog)
		  return getCatalogid() == ((LibraryCatalog)obj).getCatalogid();
		return false;
	}
	// ========================
	public String toString() {
		return getCatalogname();
	}

}
