package de.schoeso.application.web.library.swing;

import java.awt.Rectangle;
import java.util.Collection;

import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingConstants;

import de.schoeso.application.web.library.entity.LibraryItem;
import de.schoeso.application.web.library.swing.system.SwingLibraryController;

/**
 * Anzeige der Ergebnisse einer Suche in der Bibliothek 
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */

@SuppressWarnings("serial")
public class SwingLibraryHits extends SwingLibraryGUIComponent {

	private JScrollPane scroll = null;
	private JList hits = null;
	private JLabel labHits = null;
	
	public SwingLibraryHits(SwingLibraryController controller) {
		super(controller);
		controller.setSwingLibraryHits(this);
		initialize();
	}
  // ==== GUI mit Builder erstellt
	private void initialize() {
		this.setSize(291, 259);
		this.setLayout(null);
		
		labHits = new JLabel();
		labHits.setBounds(new Rectangle(1, 1, 290, 16));
		labHits.setHorizontalAlignment(SwingConstants.CENTER);
		labHits.setText("Treffer");

		hits = new JList(new DefaultListModel());
		hits.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			public void valueChanged(javax.swing.event.ListSelectionEvent e) {
				if (!e.getValueIsAdjusting())
					objectSelected();
			}
		});
		
		scroll = new JScrollPane(hits); 
		scroll.setBounds(new Rectangle(1, 23, 289, 234));
		
		this.add(scroll, null);
		this.add(labHits, null);
	}
  /** Action fr die Auswahl eines Items- Verarbeitung im Controller */
	private void objectSelected() {
		this.getSwingController().itemSelected((LibraryItem)hits.getSelectedValue());
	}
	
	/** Aktualisierung der Daten der Tabelle */
	public void setData(Collection<LibraryItem> data) {
	  // lschen 
		((DefaultListModel)hits.getModel()).removeAllElements();
		
		for (LibraryItem li : data) {
	    ((DefaultListModel)hits.getModel()).addElement(li);
		}
	}

}  //  @jve:decl-index=0:visual-constraint="10,13"
