package de.schoeso.application.web.library.swing;

import java.awt.Rectangle;
import java.util.Collection;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

import de.schoeso.application.web.library.entity.LibraryCatalog;
import de.schoeso.application.web.library.swing.system.SwingLibraryController;

/**
 * Start der Suche
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */

@SuppressWarnings("serial")
public class SwingLibrarySearch extends SwingLibraryGUIComponent {

	private JLabel labCatalog = null;
	private JComboBox ctaCombo = null;
	private JLabel labTitle;
	private JButton butSearch = null;
	private JTextField title;
	
	public SwingLibrarySearch(SwingLibraryController controller) {
		super(controller);
		controller.setSwingLibrarySearch(this);
		initialize();
	}
	
  // ==== GUI mit Builder erstellt
	private void initialize() {
		this.setSize(283, 101);
		this.setLayout(null);

		labCatalog = new JLabel();
		labCatalog.setText("Katalog:");
		labCatalog.setBounds(new Rectangle(1, 1, 81, 21));
		ctaCombo = new JComboBox();
		ctaCombo.setBounds(new Rectangle(85, 1, 197, 21));
		Collection<LibraryCatalog> cats = this.getSwingController().getCatalogs();
		for (LibraryCatalog cat : cats) { 
			ctaCombo.addItem(cat);
		}
		
		labTitle = new JLabel();
		labTitle.setText("Titel:");
		labTitle.setBounds(new Rectangle(1, 33, 81, 21));
		title = new JTextField();
		title.setBounds(new Rectangle(85, 33, 197, 21));
		
		butSearch = new JButton();
		butSearch.setBounds(new Rectangle(26, 72, 238, 26));
		butSearch.setText("Suche starten");
		butSearch.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				startSearch();
			}
		});
		
		this.add(labCatalog, null);
		this.add(ctaCombo, null);
		this.add(labTitle, null);
		this.add(title, null);
		this.add(butSearch, null);
	}
	
	private void startSearch() {
		this.getSwingController().getSearchItems((LibraryCatalog)ctaCombo.getSelectedItem(), title.getText());
	}

}  //  @jve:decl-index=0:visual-constraint="10,13"
