package de.schoeso.application.web.library.swing.system;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import de.schoeso.application.web.library.entity.LibraryItem;
import de.schoeso.application.web.library.facade.LibraryBean;

/**
 * Facade fr den Zugriff auf die Bibliothek - ergnzungen fr Swing,
 * da hier die Persistenten Objekte manuell bertragen werden.
 * Keine Verwendung des JTA, sondern direkter zugriff
 * auf die Transaktions-API des EM
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */

public class FacadeSwingLibrary extends LibraryBean {

	public FacadeSwingLibrary() {
		super();
		// Manuelles berschreiben ist mglich!
//		Map<String, String> env = new HashMap<String, String>();
//	  env.put("hibernate.connection.driver_class", "org.postgresql.Driver");
//	  env.put("hibernate.connection.username", "postgres");
//	  env.put("hibernate.connection.password", "qwerty29");
//	  
//	  env.put("hibernate.connection.url", "jdbc:postgresql://192.168.1.29:5432/library");
//	  env.put("hibernate.dialect", "org.hibernate.dialect.PostgreSQLDialect");
//	  env.put("hibernate.show_sql", "true");
//	  env.put("hibernate.hbm2ddl.auto", "update");
//	  
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("books"); // , env);   
		setEntityManager(emf.createEntityManager());
	}

	protected void setEntityManager(EntityManager em) {
		this.em = em;
	}
	
	protected EntityManager getEntityManager() {
		return em;
	}
	
	/** Sichert ein bergebenes LibraryItem-Objekt - hier muss eine Transaktiona angefodert werden */
	@Override
	public void saveItem(LibraryItem item) {
		if (item != null) {
		  em.getTransaction().begin();
		  em.merge(item);   
		  em.getTransaction().commit();
		}
	}
}
