/**
 * 
 */
package de.schoeso.application.web.libraryweb;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

import de.schoeso.application.web.library.entity.LibraryCatalog;

/**
 * Konverter fr die Catalog Objekte
 * <p>@author Dr.-Ing. Arndt Schnberg</p>
 * <p>schnberg-solutions</p>
 * <p>www.schoenberg-solutions.de</p>
 * <p>Copyright (c) 2007</p>
 */
public class CatalogConverter implements Converter {

	public CatalogConverter() {
	}

	public Object getAsObject(FacesContext context, UIComponent component, String value) {
		LibraryBackingBean bean = (LibraryBackingBean)context.getApplication().getELResolver().getValue(context.getELContext(), null, "libraryBackingBean");		
		for (LibraryCatalog item : bean.getAllCatalogs()) {
			if (item.getCatalogname().equalsIgnoreCase(value))
				return item;
		}		
		return null;
	}

	public String getAsString(FacesContext context, UIComponent component, Object value) {
		LibraryBackingBean bean = (LibraryBackingBean)context.getApplication().getELResolver().getValue(context.getELContext(), null, "libraryBackingBean");		
		for (LibraryCatalog item : bean.getAllCatalogs()) {
			if (item.equals(value)) {
				return item.getCatalogname();
			}
		}		
		return null;
	}
}
