function Ajax() {
  this.url="";
  this.params="";
  this.method="GET";
  this.onSuccess=null;
  this.onError=function (msg) {
    alert(msg)
  }
}

Ajax.prototype.doRequest=function() {
  if (!this.url) {
    this.onError("Kein URL angegeben -- Request abgebrochen.");
    return false;
  }

  if (!this.method) {
    this.method="GET";
  } else {
    this.method=this.method.toUpperCase();
  }

  var _this = this;
  
  //XMLHttpRequest-Objekt erstellen
  var xmlHttpRequest=getXMLHttpRequest();
  if (!xmlHttpRequest) {
    this.onError("Kein XMLHttpRequest-Objekt erstellt.");
    return false;
  }
  
  // Fallunterscheidung nach Uebertragungsmethode
  switch (this.method) {
    case "GET": xmlHttpRequest.open(this.method, this.url+"?"+this.params, true);
                xmlHttpRequest.onreadystatechange = readyStateHandler;
                xmlHttpRequest.send(null);
                break;
    case "POST": xmlHttpRequest.open(this.method, this.url, true);
                 xmlHttpRequest.onreadystatechange = readyStateHandler;
                 xmlHttpRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                 xmlHttpRequest.send(this.params);
                 break;
  }  

  function readyStateHandler() {
    if (xmlHttpRequest.readyState < 4) {
      return false;
    }
    if (xmlHttpRequest.status == 200 || xmlHttpRequest.status==304) {
      if (_this.onSuccess) {
        _this.onSuccess(xmlHttpRequest.responseText, xmlHttpRequest.responseXML);
      }
    } else {
      if (_this.onError) {
        _this.onError("["+xmlHttpRequest.status+" "+xmlHttpRequest.statusText+"] Fehler bei der Datenuebertragung...");
      }
    }
  }
}

function getXMLHttpRequest()  {
  if (window.XMLHttpRequest) {
    return new XMLHttpRequest();
  } else 
  if (window.ActiveXObject) {
    try {   
      return new ActiveXObject("Msxml2.XMLHTTP");
    } catch(e) {
      try {        
        return new ActiveXObject("Microsoft.XMLHTTP");  
      } catch (e) {
        return null;
      }
    }
  }
  return false;
}
