var feed = { title: "Heise-Nachrichten", url: "http://www.heise.de/newsticker/heise.rdf" };

var scrollArea, scrollbar;

function init () {
  scrollbar = new AppleVerticalScrollbar(document.getElementById("myScrollBar"));
  scrollArea = new AppleScrollArea(document.getElementById("contents"), scrollbar);
  scrollArea.scrollsHorizontally = false;
  scrollArea.singlepressScrollPixels = 15;
  
  scrollArea.focus();
  window.onfocus = function () { scrollArea.focus(); }
  window.onblur = function () { scrollArea.blur(); }
  
  if (!window.widget) { loadFeed(); }
}

var last_updated = 0;

function loadFeed () {
  var now = (new Date).getTime();
    // wenn 15 Minuten seit letztem Check vorbei
  if ((now - last_updated) > 900000) {
    Lokris.AjaxCall(feed.url, xml_loaded());
  }
}

if (window.widget) { widget.onshow = loadFeed; }

function xml_loaded ()  {
  return function (xmlDocument) {
    var items = xmlDocument.getElementsByTagNameNS("http://my.netscape.com/rdf/simple/0.9/", "item");
    var row = "";
    for ( var i = 0; i < items.length; i++ ) { 
      var title = String(items[i].getElementsByTagNameNS("http://my.netscape.com/rdf/simple/0.9/", "title")[0].firstChild.nodeValue).substr(0,60) + " ...";
      var link  = items[i].getElementsByTagNameNS("http://my.netscape.com/rdf/simple/0.9/", "link")[0].firstChild.nodeValue;
      row += "<div class=\"row " + (i % 2 == 0 ? "light" : "dark" ) + "\"><a class=\"title\" href=\"" + link + "\">" + title + "</a></div>";	
    } 
    document.getElementById("contents").innerHTML = row;	
    scrollArea.refresh();
    last_updated = (new Date).getTime();
  }
}

function clickOnFeedTitle(event) {
  if (window.widget) {
          widget.openURL (feed.url);
  } else document.location = feed.url;
}
