var feed = { title: "Heise-Nachrichten", myurl: "http://www.heise.de/newsticker/heise.rdf" };

var scrollArea, scrollbar, gDoneButton, gInfoButton;

function init () {
  scrollbar = new AppleVerticalScrollbar(document.getElementById("myScrollBar"));
  scrollArea = new AppleScrollArea(document.getElementById("contents"), scrollbar);
  scrollArea.scrollsHorizontally = false;
  scrollArea.singlepressScrollPixels = 15;

  gDoneButton = new AppleGlassButton(document.getElementById("doneButton"), "Done", hidePrefs);
  gInfoButton = new AppleInfoButton(document.getElementById("infoButton"), document.getElementById("front"), "white", "white", showPrefs);

  
  scrollArea.focus();
  window.onfocus = function () { scrollArea.focus(); }
  window.onblur = function () { scrollArea.blur(); }
  
  if (!window.widget) { loadFeed(); }
}

var last_updated = 0;

// Ladefunktion fuer D. Carls Ajax-Bibliothek
function loadFeed () {
  var now = (new Date).getTime();
    // wenn 15 Minuten seit letztem Check vorbei
  if ((now - last_updated) > 900000) {
    with (new Ajax()) {
      url = feed.myurl;
      onSuccess = xml_got;
      onError = myError;
      doRequest();
    }
  }
}

// Ladefunktion fuer S. Minterts/C. Leisegangs Lokris-Bibliothek
function loadFeed_lokris () {
  var now = (new Date).getTime();
    // wenn 15 Minuten seit letztem Check vorbei
  if ((now - last_updated) > 900000) {
    Lokris.AjaxCall(feed.url, xml_loaded());
  }
}

if (window.widget) { widget.onshow = loadFeed; }

// Verarbeitung des Lokris-Ergebnisses
function xml_loaded ()  {
  return function (xmlDocument) {
    var items = xmlDocument.getElementsByTagNameNS("http://my.netscape.com/rdf/simple/0.9/", "item");
    var row = "";
    for ( var i = 0; i < items.length; i++ ) { 
      var title = String(items[i].getElementsByTagNameNS("http://my.netscape.com/rdf/simple/0.9/", "title")[0].firstChild.nodeValue).substr(0,60) + " ...";
      var link  = items[i].getElementsByTagNameNS("http://my.netscape.com/rdf/simple/0.9/", "link")[0].firstChild.nodeValue;
      row += "<div class=\"row " + (i % 2 == 0 ? "light" : "dark" ) + "\"><a class=\"title\" href=\"" + link + "\">" + title + "</a></div>";	
    } 
    document.getElementById("contents").innerHTML = row;	
    scrollArea.refresh();
    last_updated = (new Date).getTime();
  }
}

// Verarbeitung des Ajax-Aufrufs von Carl
function xml_got (txtresp, xmlresp)  {
    var items = xmlresp.getElementsByTagNameNS("http://my.netscape.com/rdf/simple/0.9/", "item");
    var row = "";
    for ( var i = 0; i < items.length; i++ ) { 
      var title = String(items[i].getElementsByTagNameNS("http://my.netscape.com/rdf/simple/0.9/", "title")[0].firstChild.nodeValue).substr(0,60) + " ...";
      var link  = items[i].getElementsByTagNameNS("http://my.netscape.com/rdf/simple/0.9/", "link")[0].firstChild.nodeValue;
      row += "<div class=\"row " + (i % 2 == 0 ? "light" : "dark" ) + "\"><div class=\"title\"" 
             + " onclick=\"clickOnTitle (event, '" + link + "');\">" + title + "</div></div>";	
    } 

    document.getElementById("contents").innerHTML = row;	
    scrollArea.refresh();
    last_updated = (new Date).getTime();
}

function clickOnTitle (event, link) {
  if (window.widget) {
    widget.openURL (link);
  } else document.location = link;
}

function clickOnFeedTitle(event) {
  if (window.widget) {
          widget.openURL (feed.myurl);
  } else document.location = feed.myurl;
}

function myError (mymsg) {
  alert(mymsg);
}


function showPrefs() {
  var front = document.getElementById("front");
  var back = document.getElementById("back");

  if (window.widget) widget.prepareForTransition("ToBack");

  front.style.display = "none";
  back.style.display = "block";

  if (window.widget) setTimeout('widget.performTransition();', 0);
}

function hidePrefs() {
  var front = document.getElementById("front");
  var back = document.getElementById("back");

  if (window.widget) widget.prepareForTransition("ToFront");

  front.style.display = "block";
  back.style.display = "none";

  if (window.widget) setTimeout('widget.performTransition();', 0);
}
