var feed = { title:"Heise-Nachrichten", url:"http://www.heise.de/newsticker/heise.rdf" };

var scrollArea, scrollbar;

function init () {
  scrollbar = new AppleVerticalScrollbar(document.getElementById("myScrollBar"));
  scrollArea = new AppleScrollArea(document.getElementById("contents"), scrollbar);
  scrollArea.scrollsHorizontally = false;
  scrollArea.singlepressScrollPixels = 15;
  
  scrollArea.focus();
  
  window.onfocus = function () { scrollArea.focus(); }
  window.onblur = function () { scrollArea.blur(); }
  
  if (!window.widget) { loadFeed(); }
}


var last_updated = 0;
var xml_request = null;

function loadFeed () {
  var now = (new Date).getTime();
  
  // only check if 120 minutes have passed
  if ((now - last_updated) > 7200000) {
    if (xml_request != null) {
      xml_request.abort();
      xml_request = null;
    }

    /* durch AjaxCall ersetzt:
    xml_request = new XMLHttpRequest();

    xml_request.onload = function(e) { xml_loaded(e, xml_request); }
    xml_request.overrideMimeType("text/xml");
    xml_request.open("GET", feed.url);
    xml_request.setRequestHeader("Cache-Control", "no-cache");
    xml_request.send(null);
    */

    Lokris.AjaxCall(feed.url, xml_loaded(xml_request));

  }
}

if (window.widget) {
   widget.onshow = loadFeed;
}

function findChild (element, nodeName) {
  var child;
  
  for (child = element.firstChild; child != null; child = child.nextSibling) {
    if (child.nodeName == nodeName)
      return child;
  }  
  return null;
}

function xml_loaded (request) 
{
  xml_request = null;
  if (request.responseXML) {    
    var contents = document.getElementById('contents');
    while (contents.hasChildNodes()) {
      contents.removeChild(contents.firstChild);
    }
    
    // Get top level <rss> element 
    var rss = findChild(request.responseXML, 'rdf:RDF');
    if (!rss) {
      alert("no <rss> element"); 
      document.getElementById("ohnoes").style.display = "block";
      return;
    }
        
    document.getElementById("ohnoes").style.display = "none";

    var results = new Array;
    
    // Get all item elements subordinate to the channel element
    // For each element, get title, link and publication date. 
    // Note that all elements of an item are optional. 
    for( var item = findChild(rss, 'item'); item != null; item = item.nextSibling)
    {
      if( item.nodeName == 'item' ) 
      {
        var title = findChild (item, 'title');
      
        // we have to have the title to include the item in the list 
        if( title != null ) 
        {
          var link = findChild (item, 'link');
          results[results.length] = {title:title.firstChild.data, 
            link:(link != null ? link.firstChild.data : null)
           };
        }
      }
    }
    
    // sort by date
    results.sort (compFunc);
    
    // copy title and date into rows for display. Store link so it can be used when user
    // clicks on title
    nItems = results.length;
    var even = true;    
        
    for (var i = 0; i < nItems; ++i)
    {
      var item = results[i];
      var row = createRow (item.title, item.link, item.date, even);
      even = !even;
      
      contents.appendChild (row);
    }

    // update the scrollbar so scrollbar matches new data
    scrollArea.refresh();
    
    // set last_updated to the current time to keep track of the last time a request was posted
    last_updated = (new Date).getTime();
  }
}


function compFunc (a, b)
{
  if (a.date < b.date)
    return 1;
  else if (a.date > b.date)
    return -1;
  else
    return 0;
}


function createRow (title, link, date, even)
{
  var row = document.createElement ('div');
  row.setAttribute ('class', 'row ' + (even ? 'light' : 'dark'));
  
  var title_div = document.createElement ('div');
  title_div.innerText = title;
  title_div.setAttribute ('class', 'title');
  if (link != null)
  {
    title_div.setAttribute ('the_link', link);
    title_div.setAttribute ('onclick', 'clickOnTitle (event, this);');
  }
  row.appendChild (title_div);
  
  if (date != null)
  {
    var date_div = document.createElement ('div');
    date_div.setAttribute ('class', 'date');
    date_div.innerText = createDateStr (date);
    
    row.appendChild (date_div);
  }
  
  return row;  
}

function createDateStr (date)
{
  var month;
  switch (date.getMonth())
  {
    case 0: month = 'Jan'; break;
    case 1: month = 'Feb'; break;
    case 2: month = 'Mar'; break;
    case 3: month = 'Apr'; break;
    case 4: month = 'May'; break;
    case 5: month = 'Jun'; break;
    case 6: month = 'Jul'; break;
    case 7: month = 'Aug'; break;
    case 8: month = 'Sep'; break;
    case 9: month = 'Oct'; break;
    case 10: month = 'Nov'; break;
    case 11: month = 'Dec'; break;
  }  
  return month + ' ' + date.getDate();
}


function clickOnTitle (event, div)
{
  if (window.widget)
  {
    widget.openURL (div.getAttribute('the_link'));
  } else document.location = div.getAttribute('the_link');
}


function clickOnFeedTitle(event)
{
  if (window.widget) {
          widget.openURL (feed.url);
  } else document.location = feed.url;
}
