package de.heise.ix.android.calculator;

import java.util.LinkedList;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

/**
 * A simple calculator (only plus and minus are supported) 
 * for the android platform.
 * 
 * @author Markus Staeuble (fb@staeuble.de)
 * 
 */
public class SimpleCalculator extends Activity {

	/**
	 * Called when the activity is first created.
	 */
	@Override
	public void onCreate(Bundle icicle) {
		super.onCreate(icicle);
		setContentView(R.layout.calculator_layout);

		textView = (TextView) findViewById(R.id.result);
		// Add the listener for the buttons
		Button button = (Button) findViewById(R.id.button0);
		button
				.setOnClickListener(new InputButtonListener(
						0));

		// button 1
		button = (Button) findViewById(R.id.button1);
		button
				.setOnClickListener(new InputButtonListener(
						1));

		// button 2
		button = (Button) findViewById(R.id.button2);
		button
				.setOnClickListener(new InputButtonListener(
						2));

		// button 3
		button = (Button) findViewById(R.id.button3);
		button
				.setOnClickListener(new InputButtonListener(
						3));

		// button 4
		button = (Button) findViewById(R.id.button4);
		button
				.setOnClickListener(new InputButtonListener(
						4));

		// button 5
		button = (Button) findViewById(R.id.button5);
		button
				.setOnClickListener(new InputButtonListener(
						5));

		// button 6
		button = (Button) findViewById(R.id.button6);
		button
				.setOnClickListener(new InputButtonListener(
						6));

		// button 7
		button = (Button) findViewById(R.id.button7);
		button
				.setOnClickListener(new InputButtonListener(
						7));

		// button 8
		button = (Button) findViewById(R.id.button8);
		button
				.setOnClickListener(new InputButtonListener(
						8));

		// button 9
		button = (Button) findViewById(R.id.button9);
		button
				.setOnClickListener(new InputButtonListener(
						9));

		// button +
		button = (Button) findViewById(R.id.buttonP);
		button.setOnClickListener(new Operation("+"));
		// button -
		button = (Button) findViewById(R.id.buttonM);
		button.setOnClickListener(new Operation("-"));

		// button =
		button = (Button) findViewById(R.id.buttonE);
		button.setOnClickListener(new Equals());

	}

	private StringBuffer theNumber = null;
	private TextView textView = null;
	boolean lastOpEquals = false;

	/**
	 * A Listener for the the input buttons of the calculator.
	 * 
	 * @author Markus Stuble (fb@staeuble.de)
	 */
	private class InputButtonListener implements
			OnClickListener {
		private int number;

		/**
		 * Constructor.
		 * 
		 * @param number
		 *            The
		 */
		public InputButtonListener(final int number) {
			this.number = number;
		}

		public void onClick(final View view) {
			// Initialize the number storage.
			if (theNumber == null) {
				theNumber = new StringBuffer("");
			}
			// append the actual number of the input
			theNumber.append(number);

			/**
			 * If the last operation was equals we have to reset the text field.
			 */
			if (lastOpEquals) {
				textView.setText("" + number);
				lastOpEquals = false;
			} else {
				textView.append("" + number);
			}

		}
	}

	long result = 0;
	LinkedList<Long> numberQueue = new LinkedList<Long>();
	LinkedList<String> operationQueue = new LinkedList<String>();

	private class Operation implements OnClickListener {
		private String op = null;

		public Operation(final String op) {
			this.op = op;
		}

		public void onClick(View view) {
			if (lastOpEquals) {
				textView.setText("");
				lastOpEquals = false;
			} else if (theNumber != null) {
				numberQueue.add(Long
						.parseLong(theNumber
								.toString()));
				operationQueue.add(op);
				theNumber = null;
				textView.setText("");
			}
		}

	}

	/**
	 * 
	 * @author Markus Stuble (fb@staeuble.de)
	 * 
	 */
	private class Equals implements OnClickListener {

		public void onClick(View view) {
			if (numberQueue.size() > 0) {

				result = numberQueue.get(0);
				String op;

				for (int i = 1; i < numberQueue.size(); ++i) {
					op = operationQueue.get(i - 1);
					if ("+".equals(op)) {
						result += numberQueue.get(i);
					} else {
						result -= numberQueue.get(i);
					}
				}
				op = operationQueue.getLast();
				// Check whether the last input is a number
				if (theNumber != null) {
					if ("+".equals(op)) {
						result += Long
								.parseLong(theNumber
										.toString());
					} else {
						result -= Long
								.parseLong(theNumber
										.toString());
					}
				}
				textView.setText("" + result);
				lastOpEquals = true;

				/** 
				 * Clear the temporary storages for 
				 * an new calculation
				 */
				operationQueue.clear();
				numberQueue.clear();
				theNumber = null;
			}
		}
	}

}