package com.blogspot.berndschiffer.fest;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertThat;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;

public class AbschnittTest {

  private Abschnitt abschnitt = new Abschnitt("abschnittsname");

  @Test
  public void nimmtWerteFuerStellenAuf() throws Exception {
    Abschnitt abschnitt = new Abschnitt();
    abschnitt.setName("abschnittsname");
    final String ersterWert = "a";
    final int ersteStelle = 1;
    final String zweiterWert = "b";
    final int zweiteStelle = 2;
    abschnitt.add(ersteStelle, ersterWert);
    abschnitt.add(zweiteStelle, zweiterWert);
    assertThat(ersterWert, is(abschnitt.findeWertAnStelle(ersteStelle)));
    assertThat(zweiterWert, is(abschnitt.findeWertAnStelle(zweiteStelle)));
  }

  @Test
  public void gibtAnObWertInAbschnittVorhanden() throws Exception {
    final String wert = "wert";
    abschnitt.add(1, wert);
    assertThat(abschnitt, hatWert(wert));
    assertThat(abschnitt, not(hatWert("gibt's nicht")));
  }

  private static Matcher<Abschnitt> hatWert(final String wert) {
    return new TypeSafeMatcher<Abschnitt>() {

      @Override
      public boolean matchesSafely(Abschnitt abschnitt) {
        return abschnitt.hatWert(wert);
      }

      public void describeTo(Description description) {
        description.appendText("hat Wert <" + wert + ">");
      }
    };
  }  
}
