package com.blogspot.berndschiffer.fluessigererbauer;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertThat;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Test;

import com.blogspot.berndschiffer.fluessigererbauer.Abschnitt;
import com.blogspot.berndschiffer.fluessigererbauer.ErzeugeAbschnitt;

public class AbschnittTest {

	@Test
	public void nimmtMehrereWerteFuerStellenAuf() throws Exception {
		final String ersterWert = "a";
		final int ersteStelle = 1;
		final String zweiterWert = "b";
		final int zweiteStelle = 2;
		Abschnitt abschnitt = ErzeugeAbschnitt.mitNamen("abschnittsname")
				.mitWert(ersterWert).anStelle(ersteStelle).undMitWert(
						zweiterWert).anStelle(zweiteStelle).jetzt();
		assertThat(ersterWert, is(abschnitt.findeWertAnStelle(ersteStelle)));
		assertThat(zweiterWert, is(abschnitt.findeWertAnStelle(zweiteStelle)));
	}

	@Test
	public void gibtAnObWertInAbschnittVorhanden() throws Exception {
		final String wert = "wert";
		Abschnitt abschnitt = ErzeugeAbschnitt.mitNamen("abschnittsname")
				.mitWert(wert).anStelle(1).jetzt();
		assertThat(abschnitt, hatWert(wert));
		assertThat(abschnitt, not(hatWert("gibt's nicht")));
	}

	private static Matcher<Abschnitt> hatWert(final String wert) {
		return new TypeSafeMatcher<Abschnitt>() {

			@Override
			public boolean matchesSafely(Abschnitt abschnitt) {
				return abschnitt.hatWert(wert);
			}

			public void describeTo(Description description) {
				description.appendText("hat Wert <" + wert + ">");
			}
		};
	}
}
