package com.blogspot.berndschiffer.fluessigererbauer;

public class ErzeugeAbschnitt {

  private Abschnitt abschnitt = new Abschnitt();

  private ErzeugeAbschnitt(String name) {
    abschnitt.setName(name);
  }

  public static ErzeugeAbschnitt mitNamen(String name) {
    return new ErzeugeAbschnitt(name);
  }

  public AbschnittWertZuStelleDescriptor<ErzeugeAbschnitt> mitWert(String wert) {
    final ErzeugeAbschnitt erzeugeAbschnitt = this;
    return new AbschnittWertZuStelleDescriptor<ErzeugeAbschnitt>(
        new WertZuStelleAddierer<ErzeugeAbschnitt>() {
          public ErzeugeAbschnitt addWertZuStelle(String wert, int stelle) {
            abschnitt.put(stelle, wert);
            return erzeugeAbschnitt;
          }
        }, wert);
  }

  public AbschnittWertZuStelleDescriptor<ErzeugeAbschnitt> undMitWert(String wert) {
    return mitWert(wert);
  }

  public Abschnitt jetzt() {
    return abschnitt;
  }
}
